/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceDataType;

public class BinaryFTraceByteBuffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4096;
    private final RandomAccessFile fTraceFile;
    private FileChannel fFileChannel;
    private ByteBuffer fByteBuffer;
    private ByteOrder fByteOrder = ByteOrder.BIG_ENDIAN;
    private long fCurrentOffset;

    public BinaryFTraceByteBuffer(String path) throws FileNotFoundException {
        this.fTraceFile = new RandomAccessFile(path, "r");
        this.fFileChannel = this.fTraceFile.getChannel();
        this.fByteBuffer = ByteBuffer.allocate(4096);
        this.fCurrentOffset = 0L;
    }

    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.fByteOrder = byteOrder;
    }

    @Override
    public void close() throws IOException {
        this.fFileChannel.close();
        this.fTraceFile.close();
    }

    public int read() throws IOException {
        this.fByteBuffer.compact();
        int numOfBytesRead = this.fFileChannel.read(this.fByteBuffer);
        this.fByteBuffer.flip();
        return numOfBytesRead;
    }

    public byte[] getNextBytes(int byteCount) throws IOException {
        byte[] bytesArray = new byte[byteCount];
        this.fByteBuffer.flip();
        if (this.fByteBuffer.remaining() < byteCount) {
            this.read();
        }
        this.fByteBuffer.get(bytesArray);
        this.fByteBuffer.compact();
        this.fCurrentOffset += (long)byteCount;
        return bytesArray;
    }

    public String getNextString() throws IOException {
        StringBuilder strBuilder = new StringBuilder();
        this.fByteBuffer.flip();
        if (this.fByteBuffer.remaining() == 0) {
            this.read();
        }
        byte value = this.fByteBuffer.get();
        while (value > 0) {
            strBuilder.append((char)value);
            if (this.fByteBuffer.remaining() == 0) {
                this.read();
            }
            value = this.fByteBuffer.get();
        }
        this.fByteBuffer.compact();
        String returnString = strBuilder.toString();
        this.fCurrentOffset += (long)(returnString.length() + 1);
        return returnString;
    }

    public String getNextBytesAsString(long byteCount) throws IOException {
        String str;
        StringBuilder strBuilder = new StringBuilder();
        long remainingByte = byteCount;
        while (remainingByte >= 4096L) {
            str = new String(this.getNextBytes(4096));
            strBuilder.append(str);
            remainingByte -= 4096L;
        }
        str = new String(this.getNextBytes((int)remainingByte));
        strBuilder.append(str);
        return strBuilder.toString();
    }

    public int getNextInt() throws IOException {
        byte[] byteArray = this.getNextBytes(BinaryFTraceDataType.INT.getSize());
        ByteBuffer wrapped = ByteBuffer.wrap(byteArray).order(this.fByteOrder);
        return wrapped.getInt();
    }

    public double getNextDouble() throws IOException {
        byte[] byteArray = this.getNextBytes(8);
        ByteBuffer wrapped = ByteBuffer.wrap(byteArray).order(this.fByteOrder);
        return wrapped.getDouble();
    }

    public long getNextLong() throws IOException {
        byte[] byteArray = this.getNextBytes(8);
        ByteBuffer wrapped = ByteBuffer.wrap(byteArray).order(this.fByteOrder);
        return wrapped.getLong();
    }

    public short getNextShort() throws IOException {
        byte[] byteArray = this.getNextBytes(2);
        ByteBuffer wrapped = ByteBuffer.wrap(byteArray).order(this.fByteOrder);
        return wrapped.getShort();
    }

    public void movePointerToOffset(long offset) throws IOException {
        this.fByteBuffer.clear();
        this.fTraceFile.seek(offset);
        this.fCurrentOffset = offset;
    }

    public long getCurrentOffset() {
        return this.fCurrentOffset;
    }

    public long getFileSize() throws IOException {
        return this.fTraceFile.length();
    }
}

