/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.Hidden;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;

@Deprecated
@Hidden
@Path(value="/xml")
public class XmlManagerService {
    @GET
    @Produces(value={"application/json"})
    public Response getXml() {
        return Response.ok((Object)Maps.transformValues((Map)XmlUtils.listFiles(), File::getAbsolutePath)).build();
    }

    @POST
    public Response postXml(@FormParam(value="path") String path) {
        return XmlManagerService.updateXml(path, true);
    }

    @PUT
    public Response putXml(@FormParam(value="path") String path) {
        return XmlManagerService.updateXml(path, false);
    }

    @DELETE
    @Path(value="/{name}")
    public Response deleteXml(@PathParam(value="name") String name) {
        if (!XmlUtils.listFiles().containsKey(name)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        XmlUtils.deleteFiles((Iterable)ImmutableList.of((Object)Objects.requireNonNull(name)));
        XmlUtils.saveFilesStatus();
        return Response.ok().build();
    }

    private static Response updateXml(String path, boolean addFile) {
        File file = new File(path);
        IStatus status = XmlUtils.xmlValidate((File)file);
        if (status.isOK()) {
            if (addFile) {
                status = XmlUtils.addXmlFile((File)file);
            } else {
                XmlUtils.updateXmlFile((File)file);
            }
            if (status.isOK()) {
                XmlAnalysisModuleSource.notifyModuleChange();
                XmlUtils.saveFilesStatus();
                return Response.ok().build();
            }
        }
        return Response.serverError().build();
    }
}

