/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

@Schema(description="Represents the style on an element (ex. Entry, TimeGraphState, ...) returned by any output. Supports style inheritance. To avoid having too many styles, the element style can have a parent style and will have all the same style property values as the parent, and can add or override style properties.")
public interface OutputElementStyle {
    @Schema(description="Parent style key or empty if there is no parent. The parent key should match a style key defined in the style model and is used for style inheritance. A comma-delimited list of parent style keys can be used for style composition, the last one taking precedence.")
    public @Nullable String getParentKey();

    @Schema(description="Style values or empty map if there are no values. Keys and values are defined in https://github.com/eclipse-tracecompass/org.eclipse.tracecompass/blob/master/tmf/org.eclipse.tracecompass.tmf.core/src/org/eclipse/tracecompass/tmf/core/model/StyleProperties.java")
    public Map<String, StyleValue> getValues();

    @Schema(description="Supported types of a style value.", oneOf={String.class, Double.class, Integer.class})
    public static interface StyleValue {
    }
}

