/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;
import org.unitsofmeasurement.unit.UnitConverter;

public abstract class AbstractConverter
implements UnitConverter,
Serializable {
    private static final long serialVersionUID = 2557410026012911803L;
    public static final UnitConverter IDENTITY = new Identity();

    protected AbstractConverter() {
    }

    public abstract UnitConverter inverse();

    public UnitConverter concatenate(UnitConverter converter) {
        return converter == IDENTITY ? this : new CompoundImpl(this, converter);
    }

    public boolean isIdentity() {
        return false;
    }

    public List<UnitConverter> getCompoundConverters() {
        return Arrays.asList(new CompoundImpl(this, this));
    }

    public static interface Compound {
        public AbstractConverter getLeft();

        public AbstractConverter getRight();
    }

    private static final class CompoundImpl
    extends AbstractConverter
    implements Compound {
        private static final long serialVersionUID = 2242882007946934958L;
        private final AbstractConverter left;
        private final AbstractConverter right;

        private CompoundImpl(UnitConverter unitConverter, UnitConverter unitConverter2) {
            this.left = (AbstractConverter)unitConverter;
            this.right = (AbstractConverter)unitConverter2;
        }

        @Override
        public UnitConverter inverse() {
            return new CompoundImpl(this.right.inverse(), this.left.inverse());
        }

        public double convert(double value) {
            return this.left.convert(this.right.convert(value));
        }

        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return this.left.convert(this.right.convert(value, ctx), ctx);
        }

        public Number convert(Number value) {
            return this.left.convert(this.right.convert(value));
        }

        public boolean equals(Object cvtr) {
            if (this == cvtr) {
                return true;
            }
            if (!(cvtr instanceof Compound)) {
                return false;
            }
            Compound that = (Compound)cvtr;
            return this.left.equals(that.getLeft()) && this.right.equals(that.getRight());
        }

        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        public boolean isLinear() {
            return this.left.isLinear() && this.right.isLinear();
        }

        @Override
        public AbstractConverter getLeft() {
            return this.left;
        }

        @Override
        public AbstractConverter getRight() {
            return this.right;
        }

        @Override
        public UnitConverter concatenate(UnitConverter converter) {
            return converter == IDENTITY ? this : new CompoundImpl(this, converter);
        }

        @Override
        public List<UnitConverter> getCompoundConverters() {
            return Arrays.asList(new CompoundImpl(this, this));
        }
    }

    private static final class Identity
    extends AbstractConverter {
        private static final long serialVersionUID = 7675901502919547460L;

        private Identity() {
        }

        @Override
        public Identity inverse() {
            return this;
        }

        public double convert(double value) {
            return value;
        }

        public BigDecimal convert(BigDecimal value, MathContext ctx) {
            return value;
        }

        public Number convert(Number value) {
            return value;
        }

        public boolean equals(Object cvtr) {
            return this == cvtr;
        }

        public int hashCode() {
            return 0;
        }

        public boolean isLinear() {
            return true;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }
    }
}

