/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units;

import com.ibm.icu.util.TimeUnitAmount;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.QuantityAmount;
import org.eclipse.uomo.units.SI;
import org.unitsofmeasurement.quantity.Acceleration;
import org.unitsofmeasurement.quantity.AmountOfSubstance;
import org.unitsofmeasurement.quantity.Angle;
import org.unitsofmeasurement.quantity.Area;
import org.unitsofmeasurement.quantity.CatalyticActivity;
import org.unitsofmeasurement.quantity.Dimensionless;
import org.unitsofmeasurement.quantity.ElectricCapacitance;
import org.unitsofmeasurement.quantity.ElectricCharge;
import org.unitsofmeasurement.quantity.ElectricConductance;
import org.unitsofmeasurement.quantity.ElectricCurrent;
import org.unitsofmeasurement.quantity.ElectricInductance;
import org.unitsofmeasurement.quantity.ElectricPotential;
import org.unitsofmeasurement.quantity.ElectricResistance;
import org.unitsofmeasurement.quantity.Energy;
import org.unitsofmeasurement.quantity.Force;
import org.unitsofmeasurement.quantity.Frequency;
import org.unitsofmeasurement.quantity.Illuminance;
import org.unitsofmeasurement.quantity.Information;
import org.unitsofmeasurement.quantity.Length;
import org.unitsofmeasurement.quantity.LuminousFlux;
import org.unitsofmeasurement.quantity.LuminousIntensity;
import org.unitsofmeasurement.quantity.MagneticFlux;
import org.unitsofmeasurement.quantity.MagneticFluxDensity;
import org.unitsofmeasurement.quantity.MagnetomotiveForce;
import org.unitsofmeasurement.quantity.Mass;
import org.unitsofmeasurement.quantity.Power;
import org.unitsofmeasurement.quantity.Pressure;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.quantity.RadiationDoseAbsorbed;
import org.unitsofmeasurement.quantity.RadiationDoseEffective;
import org.unitsofmeasurement.quantity.RadioactiveActivity;
import org.unitsofmeasurement.quantity.SolidAngle;
import org.unitsofmeasurement.quantity.Temperature;
import org.unitsofmeasurement.quantity.Velocity;
import org.unitsofmeasurement.quantity.Volume;
import org.unitsofmeasurement.unit.Unit;

abstract class QuantityFactory<Q extends Quantity<Q>> {
    private static final ConcurrentHashMap<Class, QuantityFactory> INSTANCES = new ConcurrentHashMap();
    private static final Logger logger = Logger.getLogger(QuantityFactory.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;

    QuantityFactory() {
    }

    public static <Q extends Quantity<Q>> QuantityFactory<Q> getInstance(Class<Q> type) {
        QuantityFactory factory;
        logger.log(LOG_LEVEL, "Type: " + type + ": " + type.isInterface());
        if (!type.isInterface()) {
            if (type != null && type.getInterfaces() != null & type.getInterfaces().length > 0) {
                logger.log(LOG_LEVEL, "Type0: " + type.getInterfaces()[0]);
                Class<?> type2 = type.getInterfaces()[0];
                factory = INSTANCES.get(type2);
                if (factory != null) {
                    return factory;
                }
                if (!QuantityAmount.class.isAssignableFrom(type2)) {
                    throw new ClassCastException();
                }
                factory = new Default(type2);
                INSTANCES.put(type2, factory);
            } else {
                factory = INSTANCES.get(type);
                if (factory != null) {
                    return factory;
                }
                if (!QuantityAmount.class.isAssignableFrom(type)) {
                    throw new ClassCastException();
                }
                factory = new Default<Q>(type);
                INSTANCES.put(type, factory);
            }
        } else {
            factory = INSTANCES.get(type);
            if (factory != null) {
                return factory;
            }
            if (!Quantity.class.isAssignableFrom(type)) {
                throw new ClassCastException();
            }
            factory = new Default<Q>(type);
            INSTANCES.put(type, factory);
        }
        return factory;
    }

    protected static <Q extends Quantity<Q>> void setInstance(Class<Q> type, QuantityFactory<Q> factory) {
        if (!QuantityAmount.class.isAssignableFrom(type)) {
            throw new ClassCastException();
        }
        INSTANCES.put(type, factory);
    }

    public abstract Q create(Number var1, Unit<Q> var2);

    public abstract Unit<Q> getMetricUnit();

    private static final class Default<Q extends Quantity<Q>>
    extends QuantityFactory<Q> {
        private final Class<Q> type;
        private final Unit<Q> metricUnit;
        static final HashMap<Class, Unit> CLASS_TO_METRIC_UNIT = new HashMap();

        static {
            CLASS_TO_METRIC_UNIT.put(Dimensionless.class, AbstractUnit.ONE);
            CLASS_TO_METRIC_UNIT.put(ElectricCurrent.class, SI.AMPERE);
            CLASS_TO_METRIC_UNIT.put(LuminousIntensity.class, SI.CANDELA);
            CLASS_TO_METRIC_UNIT.put(Temperature.class, SI.KELVIN);
            CLASS_TO_METRIC_UNIT.put(Mass.class, SI.KILOGRAM);
            CLASS_TO_METRIC_UNIT.put(Length.class, SI.METRE);
            CLASS_TO_METRIC_UNIT.put(AmountOfSubstance.class, SI.MOLE);
            CLASS_TO_METRIC_UNIT.put(TimeUnitAmount.class, SI.SECOND);
            CLASS_TO_METRIC_UNIT.put(MagnetomotiveForce.class, SI.AMPERE_TURN);
            CLASS_TO_METRIC_UNIT.put(Angle.class, SI.RADIAN);
            CLASS_TO_METRIC_UNIT.put(SolidAngle.class, SI.STERADIAN);
            CLASS_TO_METRIC_UNIT.put(Information.class, SI.BIT);
            CLASS_TO_METRIC_UNIT.put(Frequency.class, SI.HERTZ);
            CLASS_TO_METRIC_UNIT.put(Force.class, SI.NEWTON);
            CLASS_TO_METRIC_UNIT.put(Pressure.class, SI.PASCAL);
            CLASS_TO_METRIC_UNIT.put(Energy.class, SI.JOULE);
            CLASS_TO_METRIC_UNIT.put(Power.class, SI.WATT);
            CLASS_TO_METRIC_UNIT.put(ElectricCharge.class, SI.COULOMB);
            CLASS_TO_METRIC_UNIT.put(ElectricPotential.class, SI.VOLT);
            CLASS_TO_METRIC_UNIT.put(ElectricCapacitance.class, SI.FARAD);
            CLASS_TO_METRIC_UNIT.put(ElectricResistance.class, SI.OHM);
            CLASS_TO_METRIC_UNIT.put(ElectricConductance.class, SI.SIEMENS);
            CLASS_TO_METRIC_UNIT.put(MagneticFlux.class, SI.WEBER);
            CLASS_TO_METRIC_UNIT.put(MagneticFluxDensity.class, SI.TESLA);
            CLASS_TO_METRIC_UNIT.put(ElectricInductance.class, SI.HENRY);
            CLASS_TO_METRIC_UNIT.put(LuminousFlux.class, SI.LUMEN);
            CLASS_TO_METRIC_UNIT.put(Illuminance.class, SI.LUX);
            CLASS_TO_METRIC_UNIT.put(RadioactiveActivity.class, SI.BECQUEREL);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseAbsorbed.class, SI.GRAY);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseEffective.class, SI.SIEVERT);
            CLASS_TO_METRIC_UNIT.put(CatalyticActivity.class, SI.KATAL);
            CLASS_TO_METRIC_UNIT.put(Velocity.class, SI.METRES_PER_SECOND);
            CLASS_TO_METRIC_UNIT.put(Acceleration.class, SI.METRES_PER_SQUARE_SECOND);
            CLASS_TO_METRIC_UNIT.put(Area.class, SI.SQUARE_METRE);
            CLASS_TO_METRIC_UNIT.put(Volume.class, SI.CUBIC_METRE);
        }

        Default(Class<Q> type) {
            this.type = type;
            this.metricUnit = CLASS_TO_METRIC_UNIT.get(type);
        }

        @Override
        public Q create(Number value, Unit<Q> unit) {
            return (Q)((Quantity)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, new GenericHandler<Q>(value, unit)));
        }

        @Override
        public Unit<Q> getMetricUnit() {
            return this.metricUnit;
        }
    }

    private static final class GenericHandler<Q extends Quantity<Q>>
    implements InvocationHandler {
        final Unit<Q> unit;
        final Number value;

        GenericHandler(Number value, Unit<Q> unit) {
            this.unit = unit;
            this.value = value;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name = method.getName();
            if (name.equals("doubleValue")) {
                Unit toUnit = (Unit)args[0];
                if (toUnit == this.unit || toUnit.equals(this.unit)) {
                    return this.value.doubleValue();
                }
                return this.unit.getConverterTo(toUnit).convert(this.value.doubleValue());
            }
            if (name.equals("longValue")) {
                Unit toUnit = (Unit)args[0];
                if (toUnit == this.unit || toUnit.equals(this.unit)) {
                    return this.value.longValue();
                }
                double doubleValue = this.unit.getConverterTo(toUnit).convert(this.value.doubleValue());
                if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                    throw new ArithmeticException("Overflow: " + doubleValue + " cannot be represented as a long");
                }
                return (long)doubleValue;
            }
            if (name.equals("getValue")) {
                return this.value;
            }
            if (name.equals("getUnit")) {
                return this.unit;
            }
            if (name.equals("toString")) {
                StringBuilder buffer = new StringBuilder();
                return buffer.append(this.value).append(' ').append(this.unit).toString();
            }
            if (name.equals("hashCode")) {
                return this.value.hashCode() * 31 + this.unit.hashCode();
            }
            if (name.equals("equals")) {
                Object obj = args[0];
                if (!(obj instanceof QuantityAmount)) {
                    return false;
                }
                QuantityAmount that = (QuantityAmount)obj;
                if (!this.unit.isCompatible((Unit)((AbstractUnit)that.unit()))) {
                    return false;
                }
                if (this.value.doubleValue() == that.doubleValue(this.unit)) {
                    return true;
                }
                return false;
            }
            if (name.equals("compareTo")) {
                QuantityAmount that = (QuantityAmount)args[0];
                return Double.compare(this.value.doubleValue(), that.doubleValue(this.unit));
            }
            throw new UnsupportedOperationException(name);
        }
    }
}

