/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.uomo.core.IName;
import org.eclipse.uomo.ucum.model.BaseUnit;
import org.eclipse.uomo.ucum.model.DefinedUnit;
import org.eclipse.uomo.ucum.model.Prefix;
import org.eclipse.uomo.ucum.model.UcumUnit;

public class UcumModel
implements IName {
    private final String version;
    private final String revision;
    private final Date revisionDate;
    private final List<Prefix> prefixes = new ArrayList<Prefix>();
    private final List<BaseUnit> baseUnits = new ArrayList<BaseUnit>();
    private final List<DefinedUnit> definedUnits = new ArrayList<DefinedUnit>();

    public UcumModel(String version, String revision, Date revisionDate) {
        this.version = version;
        this.revision = revision;
        this.revisionDate = revisionDate;
    }

    public String getName() {
        return "UCUM";
    }

    public List<Prefix> getPrefixes() {
        return this.prefixes;
    }

    public List<BaseUnit> getBaseUnits() {
        return this.baseUnits;
    }

    public List<DefinedUnit> getDefinedUnits() {
        return this.definedUnits;
    }

    public String getRevision() {
        return this.revision;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public String getVersion() {
        return this.version;
    }

    public UcumUnit getUnit(String code) {
        for (UcumUnit ucumUnit : this.getBaseUnits()) {
            if (!ucumUnit.getCode().equals(code)) continue;
            return ucumUnit;
        }
        for (UcumUnit ucumUnit : this.getDefinedUnits()) {
            if (!ucumUnit.getCode().equals(code)) continue;
            return ucumUnit;
        }
        return null;
    }

    public BaseUnit getBaseUnit(String code) {
        for (BaseUnit unit : this.getBaseUnits()) {
            if (!unit.getCode().equals(code)) continue;
            return unit;
        }
        return null;
    }
}

