/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.util.HashMap;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.unitsofmeasurement.quantity.Quantity;
import org.unitsofmeasurement.unit.Dimension;
import org.unitsofmeasurement.unit.Unit;
import org.unitsofmeasurement.unit.UnitConverter;

public final class AlternateUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = -1234567854321234567L;
    private final Unit<?> parent;
    private final String symbol;

    public AlternateUnit(String symbol, Unit<?> parent) {
        this(symbol, (AbstractUnit)parent);
    }

    public AlternateUnit(String symbol, AbstractUnit<?> parent) {
        if (parent == null || !parent.isUnscaledMetric()) {
            throw new UnsupportedOperationException(parent + " is not an unscaled metric unit");
        }
        this.parent = parent;
        this.symbol = symbol;
        HashMap<String, Unit<?>> hashMap = AbstractUnit.SYMBOL_TO_UNIT;
        synchronized (hashMap) {
            AlternateUnit existingUnit;
            AbstractUnit unit = (AbstractUnit)AbstractUnit.SYMBOL_TO_UNIT.get(symbol);
            if (unit == null) {
                AbstractUnit.SYMBOL_TO_UNIT.put(symbol, this);
                return;
            }
            if (unit instanceof AlternateUnit && symbol.equals((existingUnit = (AlternateUnit)unit).getSymbol()) && this.parent.equals(existingUnit.parent)) {
                return;
            }
            throw new IllegalArgumentException("Symbol " + symbol + " is associated to a different unit");
        }
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Unit<Q> getSystemUnit() {
        return this.toMetric();
    }

    @Override
    protected final AbstractUnit<Q> toMetric() {
        return this;
    }

    @Override
    public final UnitConverter getConverterToMetric() {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof AlternateUnit)) {
            return false;
        }
        AlternateUnit thatUnit = (AlternateUnit)((Object)that);
        return this.symbol.equals(thatUnit.symbol);
    }

    @Override
    public Dimension getDimension() {
        return this.parent.getDimension();
    }

    @Override
    public UnitConverter getDimensionalTransform() {
        return ((AbstractUnit)this.parent).getDimensionalTransform();
    }

    @Override
    public int hashCode() {
        return this.symbol.hashCode();
    }
}

