/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.system;

import org.eclipse.uomo.units.AbstractSystemOfUnits;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.Messages;
import org.eclipse.uomo.units.SI;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.unitsofmeasurement.quantity.Angle;
import org.unitsofmeasurement.quantity.Area;
import org.unitsofmeasurement.quantity.Energy;
import org.unitsofmeasurement.quantity.Information;
import org.unitsofmeasurement.quantity.Length;
import org.unitsofmeasurement.quantity.Mass;
import org.unitsofmeasurement.quantity.Power;
import org.unitsofmeasurement.quantity.Temperature;
import org.unitsofmeasurement.quantity.Time;
import org.unitsofmeasurement.quantity.Velocity;
import org.unitsofmeasurement.quantity.Volume;
import org.unitsofmeasurement.unit.SystemOfUnits;
import org.unitsofmeasurement.unit.Unit;

public final class USCustomary
extends AbstractSystemOfUnits {
    private static final USCustomary INSTANCE = new USCustomary();
    public static final Unit<Length> METER = SI.METRE;
    public static final Unit<Length> FOOT = USCustomary.addUnit(METER.multiply(3048.0).divide(10000.0));
    public static final Unit<Length> FOOT_SURVEY = USCustomary.addUnit(METER.multiply(1200.0).divide(3937.0));
    public static final Unit<Length> YARD = USCustomary.addUnit(FOOT.multiply(3.0));
    public static final Unit<Length> INCH = USCustomary.addUnit(FOOT.divide(12.0));
    public static final Unit<Length> MILE = USCustomary.addUnit(METER.multiply(1609344.0).divide(1000.0));
    public static final Unit<Length> LIGHT_YEAR = USCustomary.addUnit(SI.METRE.multiply(9.460528405E15));
    public static final Unit<Length> NAUTICAL_MILE = USCustomary.addUnit(METER.multiply(1852.0));
    public static final Unit<Mass> POUND = USCustomary.addUnit(SI.KILOGRAM.multiply(4.5359237E7).divide(1.0E8), Messages.US_lb_name);
    public static final Unit<Mass> OUNCE = USCustomary.addUnit(POUND.divide(16.0));
    public static final Unit<Mass> TON = USCustomary.addUnit(POUND.multiply(2000.0));
    public static final Unit<Temperature> RANKINE = USCustomary.addUnit(SI.KELVIN.multiply(5.0).divide(9.0));
    public static final Unit<Temperature> FAHRENHEIT = USCustomary.addUnit(RANKINE.add(459.67));
    public static final Unit<Angle> REVOLUTION = USCustomary.addUnit(SI.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class));
    public static final Unit<Angle> DEGREE_ANGLE = USCustomary.addUnit(REVOLUTION.divide(360.0));
    public static final Unit<Angle> MINUTE_ANGLE = USCustomary.addUnit(DEGREE_ANGLE.divide(60.0));
    public static final Unit<Angle> SECOND_ANGLE = USCustomary.addUnit(MINUTE_ANGLE.divide(60.0));
    public static final Unit<Angle> CENTIRADIAN = USCustomary.addUnit(SI.RADIAN.divide(100.0));
    public static final Unit<Angle> GRADE = USCustomary.addUnit(REVOLUTION.divide(400.0));
    public static final Unit<Time> MINUTE = USCustomary.addUnit(SI.SECOND.multiply(60.0));
    public static final Unit<Time> HOUR = USCustomary.addUnit(MINUTE.multiply(60.0));
    public static final Unit<Velocity> FEET_PER_SECOND = USCustomary.addUnit(FOOT.divide(SI.SECOND)).asType(Velocity.class);
    public static final Unit<Velocity> MILES_PER_HOUR = USCustomary.addUnit(MILE.divide(HOUR)).asType(Velocity.class);
    public static final Unit<Velocity> KNOT = USCustomary.addUnit(NAUTICAL_MILE.divide(HOUR)).asType(Velocity.class);
    public static final Unit<Area> SQUARE_FOOT = USCustomary.addUnit(new ProductUnit((AbstractUnit)FOOT.multiply(FOOT)));
    public static final Unit<Area> ARE = USCustomary.addUnit(SI.SQUARE_METRE.multiply(100.0));
    static final Unit<Area> HECTARE = USCustomary.addUnit(ARE.multiply(100.0));
    public static final Unit<Information> BYTE = USCustomary.addUnit(SI.BIT.multiply(8.0));
    public static final Unit<Information> OCTET = BYTE;
    public static final Unit<Energy> ELECTRON_VOLT = USCustomary.addUnit(SI.JOULE.multiply(1.602176462E-19));
    public static final Unit<Power> HORSEPOWER = USCustomary.addUnit(SI.WATT.multiply(735.499));
    public static final Unit<Volume> LITER = USCustomary.addUnit(SI.CUBIC_METRE.divide(1000.0));
    public static final Unit<Volume> CUBIC_INCH = USCustomary.addUnit(INCH.pow(3).asType(Volume.class));
    public static final Unit<Volume> GALLON_DRY = USCustomary.addUnit(CUBIC_INCH.multiply(2688025.0).divide(10000.0));
    public static final Unit<Volume> GALLON_LIQUID = USCustomary.addUnit(CUBIC_INCH.multiply(231.0));
    public static final Unit<Volume> OUNCE_LIQUID = USCustomary.addUnit(GALLON_LIQUID.divide(128.0));
    public static final Unit<Volume> MINIM = USCustomary.addUnit(SI.Prefix.MICRO(LITER).multiply(61.61152));
    public static final Unit<Volume> FLUID_DRAM = USCustomary.addUnit(MINIM.multiply(60.0));
    public static final Unit<Volume> TEASPOON = USCustomary.addUnit(MINIM.multiply(80.0));
    public static final Unit<Volume> TABLESPOON = USCustomary.addUnit(TEASPOON.multiply(3.0));
    public static final Unit<Volume> OIL_BARREL = USCustomary.addUnit(LITER.multiply(238.481));

    private USCustomary() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

