/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.xml.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.uomo.xml.IXMLWriter;
import org.eclipse.uomo.xml.XMLUtil;
import org.eclipse.uomo.xml.impl.XMLNamespace;
import org.eclipse.uomo.xml.impl.XMLWriterState;
import org.eclipse.uomo.xml.impl.XMLWriterStateStack;

public class XMLWriter
extends OutputStreamWriter
implements IXMLWriter {
    private boolean xmlHeader = true;
    private String charset;
    private boolean prettyBase;
    private boolean prettyHeader;
    private boolean pendingClose;
    private boolean pendingOpen;
    private String pendingComment;
    private int lineType = 0;
    private OutputStream stream;
    private boolean started = false;
    private String[] specialAttributeNames = new String[]{"id", "name"};
    private boolean sortAttributes;
    private int attributeLineWrap;
    public static final int LINE_UNIX = 0;
    public static final int LINE_WINDOWS = 1;
    private String[][] attributes;
    private XMLWriterStateStack levels = new XMLWriterStateStack();

    public XMLWriter(OutputStream stream, String charset) throws UnsupportedEncodingException {
        super(stream, charset);
        this.stream = stream;
        this.charset = charset;
    }

    protected boolean condition(boolean bTest, String message) throws IOException {
        if (!bTest) {
            throw new IOException(message);
        }
        return bTest;
    }

    public static String getXMLCharsetName(String charset) throws IOException {
        if (charset == null || charset.equals("")) {
            return "UTF-8";
        }
        if (charset.equals("US-ASCII")) {
            return "UTF-8";
        }
        if (XMLUtil.charSetImpliesAscii(charset)) {
            return "ISO-8859-1";
        }
        if (charset.equals("UTF-8")) {
            return "UTF-8";
        }
        if (charset.equals("UTF-16") || charset.equals("UTF-16BE") || charset.equals("UTF-16LE")) {
            return "UTF-16";
        }
        throw new IOException("Unknown charset encoding " + charset);
    }

    @Override
    public void start() throws IOException {
        this.condition(!this.started, "attempt to start after starting");
        this.levels.clear();
        this.attributes = null;
        try {
            if (this.xmlHeader) {
                this.write("<?xml version=\"1.0\" encoding=\"" + XMLWriter.getXMLCharsetName(this.charset) + "\"?>");
                if (this.prettyBase || this.prettyHeader) {
                    this.write(this.lineType == 0 ? "\n" : "\r\n");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage());
        }
        this.started = true;
    }

    private void checkStarted() throws IOException {
        this.condition(this.started, "not started");
    }

    private void checkInElement() throws IOException {
        this.condition(this.levels.size() > 0, "not in an element");
    }

    private void addAttribute(String name, String value) throws IOException {
        this.addAttribute(name, value, false);
    }

    private void addAttribute(String name, String value, boolean noLines) throws IOException {
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        this.newLevelIfRequired();
        value = XMLUtil.escapeXML(value, this.charset, noLines);
        if (this.attributes == null) {
            this.attributes = new String[][]{{name, value}};
        } else {
            String[][] newattr = new String[this.attributes.length + 1][];
            int i = 0;
            while (i < this.attributes.length) {
                this.condition(!this.attributes[i][0].equals(name), "attempt to define attribute with name " + name + " more than once");
                newattr[i] = this.attributes[i];
                ++i;
            }
            this.attributes = newattr;
            this.attributes[this.attributes.length - 1] = new String[]{name, value};
        }
    }

    protected String getAttribute(String name) {
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.length) {
                if (this.attributes[i][0].equals(name)) {
                    return this.attributes[i][1];
                }
                ++i;
            }
        }
        return null;
    }

    protected void setAttribute(String name, String value) throws IOException {
        this.newLevelIfRequired();
        if (this.attributes == null) {
            this.addAttribute(name, value, false);
        } else {
            int i = 0;
            while (i < this.attributes.length) {
                if (this.attributes[i][0].equals(name)) {
                    this.attributes[i][1] = XMLUtil.escapeXML(value, this.charset, false);
                    return;
                }
                ++i;
            }
            this.addAttribute(name, value);
        }
    }

    protected void commitAttributes() throws IOException {
    }

    private boolean nameIsSpecial(String name) {
        int i = 0;
        while (i < this.specialAttributeNames.length) {
            String n = this.specialAttributeNames[i];
            if (n.equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void writeAttributes(int col) throws IOException {
        this.commitAttributes();
        if (this.attributes != null && this.sortAttributes) {
            this.sortAttributes();
        }
        int c = col;
        c = this.writeAttributeSet(true, c, col);
        this.writeAttributeSet(false, c, col);
        this.attributes = null;
    }

    private void sortAttributes() {
        int i = 0;
        while (i < this.attributes.length - 1) {
            int j = 0;
            while (j < this.attributes.length - 1) {
                if (String.CASE_INSENSITIVE_ORDER.compare(this.attributes[j][0], this.attributes[j + 1][0]) < 0) {
                    String[] t = this.attributes[j];
                    this.attributes[j] = this.attributes[j + 1];
                    this.attributes[j + 1] = t;
                }
                ++j;
            }
            ++i;
        }
    }

    private int writeAttributeSet(boolean special, int col, int wrap) throws IOException {
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.length) {
                String[] element = this.attributes[i];
                if (this.nameIsSpecial(element[0]) == special) {
                    col = col + element[0].length() + element[1].length() + 4;
                    if (this.isPretty() && this.attributeLineWrap > 0 && col > this.attributeLineWrap && col > wrap) {
                        this.write(this.lineType == 0 ? "\n" : "\r\n");
                        int j = 0;
                        while (j < wrap) {
                            this.write(" ");
                            ++j;
                        }
                        col = wrap;
                    }
                    this.write(32);
                    this.write(element[0]);
                    this.write("=\"");
                    if (element[1] != null) {
                        this.write(element[1]);
                    }
                    this.write("\"");
                }
                ++i;
            }
        }
        return col;
    }

    @Override
    public void attribute(String namespace, String name, String value, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || value != null && !value.equals("")) {
            this.attribute(namespace, name, value);
        }
    }

    @Override
    public void attribute(String namespace, String name, String value) throws IOException {
        this.checkStarted();
        if (namespace == null || namespace.equals("")) {
            this.addAttribute(name, value);
        } else {
            this.addAttribute(String.valueOf(this.getNSAbbreviation(namespace)) + name, value);
        }
    }

    @Override
    public void attribute(String name, String value, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || value != null && !value.equals("")) {
            this.attribute(name, value);
        }
    }

    @Override
    public void attribute(String name, String value) throws IOException {
        this.checkStarted();
        this.addAttribute(name, value);
    }

    @Override
    public void attributeNoLines(String name, String value) throws IOException {
        this.checkStarted();
        this.addAttribute(name, value, true);
    }

    private void newLevelIfRequired() throws IOException {
        if (!this.pendingOpen) {
            if (!this.levels.empty()) {
                this.levels.current().seeChild();
            }
            XMLWriterState level = new XMLWriterState();
            level.setPretty(this.isPretty());
            this.levels.push(level);
            this.pendingOpen = true;
        }
    }

    private void defineNamespace(String namespace, String abbrev) throws IOException {
        this.checkStarted();
        if (namespace != null && !namespace.equals("")) {
            if (abbrev.equals("")) {
                abbrev = null;
            }
            this.newLevelIfRequired();
            this.levels.current().addNamespaceDefn(namespace, abbrev);
            if (abbrev == null) {
                this.addAttribute("xmlns", namespace);
            } else {
                this.addAttribute("xmlns:" + abbrev, namespace);
            }
        }
    }

    public XMLNamespace findByNamespace(String namespace) {
        int i = this.levels.size() - 1;
        while (i >= 0) {
            XMLNamespace ns = this.levels.item(i).getDefnByNamespace(namespace);
            if (ns != null) {
                return ns;
            }
            --i;
        }
        return null;
    }

    @Override
    public boolean namespaceDefined(String namespace) {
        return namespace == null || namespace.equals("") || this.findByNamespace(namespace) != null;
    }

    public XMLNamespace findByAbbreviation(String abbreviation) {
        int i = this.levels.size() - 1;
        while (i >= 0) {
            XMLNamespace ns = this.levels.item(i).getDefnByAbbreviation(abbreviation);
            if (ns != null) {
                return ns;
            }
            --i;
        }
        return null;
    }

    @Override
    public boolean abbreviationDefined(String abbreviation) {
        return this.findByAbbreviation(abbreviation) != null;
    }

    protected XMLNamespace findDefaultNamespace() {
        int i = this.levels.size() - 1;
        while (i >= 0) {
            XMLNamespace ns = this.levels.item(i).getDefaultNamespace();
            if (ns != null) {
                return ns;
            }
            --i;
        }
        return null;
    }

    @Override
    public String getDefaultNamespace() {
        XMLNamespace ns = this.findDefaultNamespace();
        if (ns == null) {
            return null;
        }
        return ns.getNamespace();
    }

    @Override
    public void namespace(String namespace) throws IOException {
        if (!this.namespaceDefined(namespace)) {
            int index = 0;
            while (this.abbreviationDefined("ns" + Integer.toString(index))) {
                ++index;
            }
            this.defineNamespace(namespace, "ns" + Integer.toString(index));
        }
    }

    @Override
    public void setDefaultNamespace(String namespace) throws IOException {
        if (namespace == null && this.getDefaultNamespace() != null || namespace != null && !namespace.equals(this.getDefaultNamespace())) {
            this.defineNamespace(namespace, "");
        }
    }

    @Override
    public void namespace(String namespace, String abbreviation) throws IOException {
        XMLNamespace ns = this.findByAbbreviation(abbreviation);
        if (ns == null || !ns.getNamespace().equals(namespace)) {
            this.defineNamespace(namespace, abbreviation);
        }
    }

    private String getNSAbbreviation(String namespace) throws IOException {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml:";
        }
        if (namespace == null || "".equals(namespace)) {
            return "";
        }
        XMLNamespace ns = this.findByNamespace(namespace);
        if (ns == null) {
            throw new IOException("Namespace " + namespace + " is not defined");
        }
        if (ns.getAbbreviation() == null) {
            return "";
        }
        return String.valueOf(ns.getAbbreviation()) + ":";
    }

    @Override
    public void comment(String comment, boolean doPretty) throws IOException {
        this.checkStarted();
        if (this.pendingClose) {
            this.write(62);
            this.writePendingComment();
            this.pendingClose = false;
        }
        if (doPretty) {
            this.writePretty();
            if (this.isPretty()) {
                int i = 0;
                while (i < this.levels.size()) {
                    this.write("  ");
                    ++i;
                }
            }
        }
        if (this.levels.inComment()) {
            this.write("<!-- " + comment + " -- >");
        } else {
            this.write("<!-- " + comment + " -->");
        }
        if (doPretty && !this.isPretty()) {
            this.writePretty();
        }
    }

    private void writePendingComment() throws IOException {
        if (this.pendingComment != null) {
            if (this.isPretty()) {
                this.write("   ");
            }
            if (this.levels.inComment()) {
                this.write("<!-- " + this.pendingComment + " -- >");
            } else {
                this.write("<!-- " + this.pendingComment + " -->");
            }
        }
    }

    @Override
    public void open(String namespace, String name) throws IOException {
        this.open(namespace, name, null);
    }

    @Override
    public void open(String namespace, String name, String comment) throws IOException {
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        this.checkStarted();
        if (this.pendingClose) {
            this.write(62);
            this.writePendingComment();
            this.pendingClose = false;
        }
        if (name == null) {
            throw new IOException("name is null");
        }
        this.newLevelIfRequired();
        this.levels.current().setName(name);
        this.levels.current().setNamespace(namespace);
        int col = this.writePretty();
        this.write(60);
        if (namespace == null) {
            this.write(name);
            col = col + name.length() + 1;
        } else {
            String n = String.valueOf(this.getNSAbbreviation(namespace)) + name;
            this.write(n);
            col = col + n.length() + 1;
        }
        this.writeAttributes(col);
        this.pendingOpen = false;
        this.pendingClose = true;
        this.pendingComment = comment;
    }

    @Override
    public void close(String name) throws IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            throw new IOException("Unable to close null|" + name + ", nothing to close");
        }
        if (this.levels.current().getNamespace() != null || !this.levels.current().getName().equals(name)) {
            throw new IOException("Unable to close null|" + name + ", found " + this.levels.current().getNamespace() + "|" + this.levels.current().getName());
        }
        this.close();
    }

    @Override
    public void close(String namespace, String name) throws IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            throw new IOException("Unable to close " + namespace + "|" + name + ", nothing to close");
        }
        if (!this.levels.current().getNamespace().equals(namespace) || !this.levels.current().getName().equals(name)) {
            throw new IOException("Unable to close " + namespace + "|" + name + ", found " + this.levels.current().getNamespace() + "|" + this.levels.current().getName());
        }
        this.close();
    }

    @Override
    public void closeToLevel(int count) throws IOException {
        while (this.levels.size() > count) {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            super.close();
        } else {
            if (this.pendingClose) {
                this.write("/>");
                this.writePendingComment();
                this.pendingClose = false;
            } else {
                if (this.levels.current().hasChildren()) {
                    this.writePretty();
                }
                this.write("</");
                if (this.levels.current().getNamespace() == null) {
                    this.write(this.levels.current().getName());
                } else {
                    this.write(String.valueOf(this.getNSAbbreviation(this.levels.current().getNamespace())) + this.levels.current().getName());
                }
                this.write(62);
            }
            this.levels.pop();
        }
    }

    @Override
    public void open(String name) throws IOException {
        this.open(null, name);
    }

    @Override
    public void element(String namespace, String name, String content, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || content != null && !content.equals("")) {
            this.element(namespace, name, content);
        }
    }

    @Override
    public void element(String namespace, String name, String content, String comment) throws IOException {
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        this.open(namespace, name, comment);
        this.text(content);
        this.close();
    }

    @Override
    public void element(String namespace, String name, String content) throws IOException {
        if (!XMLUtil.isNMToken(name)) {
            throw new IOException("XML name " + name + " is not valid");
        }
        this.open(namespace, name);
        this.text(content);
        this.close();
    }

    @Override
    public void element(String name, String content, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || content != null && !content.equals("")) {
            this.element(null, name, content);
        }
    }

    @Override
    public void element(String name, String content) throws IOException {
        this.element(null, name, content);
    }

    @Override
    public void text(String content) throws IOException {
        this.text(content, false);
    }

    @Override
    public void text(String content, boolean dontEscape) throws IOException {
        this.checkInElement();
        if (content != null) {
            if (this.pendingClose) {
                this.write(">");
                this.writePendingComment();
                this.pendingClose = false;
            }
            if (dontEscape) {
                this.write(content);
            } else {
                this.write(XMLUtil.escapeXML(content, this.charset, false));
            }
        }
    }

    @Override
    public void cData(String text) throws IOException {
        this.text("<![CDATA[" + text + "]]>");
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.checkInElement();
        if (this.pendingClose) {
            this.write(">");
            this.writePendingComment();
            this.pendingClose = false;
        }
        this.flush();
        this.stream.write(bytes);
    }

    @Override
    public boolean isPretty() throws IOException {
        return this.levels == null || this.levels.empty() ? this.prettyBase : this.levels.current().isPretty();
    }

    @Override
    public void setPretty(boolean pretty) throws IOException {
        if (this.levels == null || this.levels.empty()) {
            this.prettyBase = pretty;
        } else {
            this.levels.current().setPretty(pretty);
        }
    }

    @Override
    public void startCommentBlock() throws IOException {
        if (this.levels.inComment()) {
            throw new IOException("cannot nest comments");
        }
        this.levels.current().setInComment(true);
        if (this.isPretty()) {
            this.writePretty();
        }
        this.write("<!--");
        if (this.isPretty()) {
            this.writePretty();
        }
    }

    @Override
    public void endCommentBlock() throws IOException {
        if (!this.levels.inComment()) {
            throw new IOException("cannot close a comment block when it is open");
        }
        if (!this.levels.current().isInComment()) {
            throw new IOException("cannot close a comment block when it is open");
        }
        if (this.isPretty()) {
            this.writePretty();
        }
        this.write("-->");
        if (this.isPretty()) {
            this.writePretty();
        }
        this.levels.current().setInComment(false);
    }

    public boolean isSortAttributes() {
        return this.sortAttributes;
    }

    public void setSortAttributes(boolean sortAttributes) {
        this.sortAttributes = sortAttributes;
    }

    public boolean isPrettyHeader() {
        return this.prettyHeader;
    }

    public void setPrettyHeader(boolean pretty) {
        this.prettyHeader = pretty;
    }

    public int writePretty() throws IOException {
        return this.writePretty(true);
    }

    public int writePretty(boolean eoln) throws IOException {
        if (this.isPretty()) {
            if (eoln) {
                this.write(this.lineType == 0 ? "\n" : "\r\n");
            }
            int i = 0;
            while (i < this.levels.size() - 1) {
                this.write("  ");
                ++i;
            }
            return (this.levels.size() - 1) * 2;
        }
        return 0;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int lineType) {
        this.lineType = lineType;
    }

    public boolean isXmlHeader() {
        return this.xmlHeader;
    }

    public void setXmlHeader(boolean xmlHeader) {
        this.xmlHeader = xmlHeader;
    }

    public String[] getSpecialAttributeNames() {
        return this.specialAttributeNames;
    }

    public void setSpecialAttributeNames(String[] specialAttributeNames) {
        this.specialAttributeNames = specialAttributeNames;
    }

    public int getAttributeLineWrap() {
        return this.attributeLineWrap;
    }

    public void setAttributeLineWrap(int attributeLineWrap) {
        this.attributeLineWrap = attributeLineWrap;
    }

    public void escapedText(String content) throws IOException {
        this.text("");
        int i = content.length();
        if (this.isPretty()) {
            while (i > 0 && (content.charAt(i - 1) == '\r' || content.charAt(i - 1) == '\n')) {
                --i;
            }
        }
        this.write(content.substring(0, i));
    }
}

