/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.util.numbers;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.uomo.util.numbers.DecimalFormatOptions;
import org.eclipse.uomo.util.numbers.NumberValidator;
import org.eclipse.uomo.util.numbers.RealFormatOptions;
import org.eclipse.uomo.util.numbers.UOMoNumberFormatException;

public abstract class NumberFormatUtilities {
    public static String validateReal(String source, RealFormatOptions options) {
        try {
            new NumberValidator(source, options).validateReal();
            return null;
        }
        catch (NumberFormatException e) {
            return e.getMessage();
        }
    }

    public static BigDecimal parseReal(String source, RealFormatOptions options) throws UOMoNumberFormatException {
        return new NumberValidator(source, null).parseReal();
    }

    @Deprecated
    public static String formatReal(BigDecimal num) {
        return NumberFormat.getInstance(Locale.US).format(num);
    }

    @Deprecated
    public static String formatReal(Double num) {
        return NumberFormat.getInstance(Locale.US).format(num);
    }

    public static String validateInteger(String source) {
        try {
            new NumberValidator(source, null).validateInteger();
            return null;
        }
        catch (NumberFormatException e) {
            return e.getMessage();
        }
    }

    public static long parseInteger(String source) throws UOMoNumberFormatException {
        return new NumberValidator(source, null).parseInteger();
    }

    public static String formatInteger(Long num) {
        return NumberFormat.getInstance(Locale.US).format(num);
    }

    public static String formatInteger(long num) {
        return NumberFormat.getInstance(Locale.US).format(num);
    }

    public static String validateDecimal(String source, DecimalFormatOptions options) {
        try {
            new NumberValidator(source, options).validateDecimal();
            return null;
        }
        catch (NumberFormatException e) {
            return e.getMessage();
        }
    }

    public static BigDecimal parseDecimal(String source, DecimalFormatOptions options) throws UOMoNumberFormatException {
        return new NumberValidator(source, null).parseDecimal();
    }

    public static String formatDecimal(BigDecimal num) {
        return NumberFormat.getInstance(Locale.US).format(num);
    }
}

