/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.util.Map;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractUnit;

public class AnnotatedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 1L;
    private final String annotation;
    private final AbstractUnit<Q> actualUnit;

    public AbstractUnit<Q> getActualUnit() {
        return this.actualUnit;
    }

    public AnnotatedUnit(AbstractUnit<Q> actualUnit, String annotation) {
        this.actualUnit = actualUnit instanceof AnnotatedUnit ? ((AnnotatedUnit)actualUnit).actualUnit : actualUnit;
        this.annotation = annotation;
    }

    public final AbstractUnit<Q> annotate(String annotation) {
        return new AnnotatedUnit<Q>(this, annotation);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public String getSymbol() {
        return this.actualUnit.getSymbol();
    }

    public Unit<Q> getSystemUnit() {
        return this.toMetric();
    }

    @Override
    public Map<Unit<?>, Integer> getProductUnits() {
        return this.actualUnit.getProductUnits();
    }

    @Override
    protected Unit<Q> toMetric() {
        return this.actualUnit.getSystemUnit();
    }

    @Override
    public UnitConverter getConverterToMetric() {
        return this.actualUnit.getConverterToMetric();
    }

    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return this.actualUnit.getBaseUnits();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof AnnotatedUnit)) {
            return false;
        }
        AnnotatedUnit thatUnit = (AnnotatedUnit)that;
        return this.actualUnit.equals(thatUnit.actualUnit) && this.annotation.equals(thatUnit.annotation);
    }

    @Override
    public int hashCode() {
        return this.actualUnit.hashCode() + this.annotation.hashCode();
    }
}

