/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.impl.QuantityDimension;
import org.eclipse.uomo.units.impl.StandardModel;

public abstract class DimensionalModel {
    private static DimensionalModel currentModel = new StandardModel();

    public static DimensionalModel current() {
        return currentModel;
    }

    protected static void setCurrent(DimensionalModel model) {
        currentModel = model;
    }

    protected DimensionalModel() {
    }

    public Dimension getFundamentalDimension(Dimension dimension) {
        Map dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return dimension;
        }
        Dimension fundamentalProduct = QuantityDimension.NONE;
        for (Map.Entry e : dimensions.entrySet()) {
            fundamentalProduct = fundamentalProduct.multiply(this.getFundamentalDimension((Dimension)e.getKey())).pow(((Integer)e.getValue()).intValue());
        }
        return fundamentalProduct;
    }

    public UnitConverter getDimensionalTransform(Dimension dimension) {
        Map dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return AbstractConverter.IDENTITY;
        }
        UnitConverter toFundamental = AbstractConverter.IDENTITY;
        for (Map.Entry e : dimensions.entrySet()) {
            UnitConverter cvtr = this.getDimensionalTransform((Dimension)e.getKey());
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException("Non-linear dimensional transform");
            }
            int pow = (Integer)e.getValue();
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            int j = 0;
            while (j < pow) {
                toFundamental = toFundamental.concatenate(cvtr);
                ++j;
            }
        }
        return toFundamental;
    }
}

