/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractQuantity;
import org.eclipse.uomo.units.impl.DoubleQuantity;
import org.eclipse.uomo.units.impl.FloatQuantity;
import org.eclipse.uomo.units.impl.IntegerQuantity;
import org.eclipse.uomo.units.impl.LongQuantity;
import org.eclipse.uomo.units.impl.ShortQuantity;
import org.eclipse.uomo.units.impl.format.QuantityFormat;

public class NumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private final Number value;
    private final boolean isExact;

    protected NumberQuantity(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
        this.isExact = false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        Unit myUnit = this.getUnit();
        UnitConverter converter = myUnit.getConverterTo(unit);
        return converter.convert(this.getValue().doubleValue());
    }

    protected final int intValue(Unit<Q> unit) throws ArithmeticException {
        long longValue = this.longValue(unit);
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Cannot convert " + longValue + " to int (overflow)");
        }
        return (int)longValue;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public boolean isExact() {
        return this.isExact;
    }

    protected Quantity<Q> add(AbstractQuantity<Q> that) {
        Quantity<Q> thatToUnit = that.to(this.getUnit());
        return new NumberQuantity(this.getValue().doubleValue() + thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    @Override
    public String toString() {
        return String.valueOf(String.valueOf(this.getValue())) + " " + String.valueOf(this.getUnit());
    }

    public Quantity<?> multiply(Quantity<?> that) {
        Unit unit = this.getUnit().multiply(that.getUnit());
        return new NumberQuantity<Q>(this.getValue().doubleValue() * that.getValue().doubleValue(), unit);
    }

    public Quantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.getValue().doubleValue() * that.doubleValue(), this.getUnit());
    }

    public Quantity<Q> divide(Quantity<?> that) {
        Unit unit = this.getUnit().divide(that.getUnit());
        return new NumberQuantity<Q>(this.getValue().doubleValue() / that.getValue().doubleValue(), unit);
    }

    public Quantity<Q> divide(Number that) {
        return NumberQuantity.of(this.getValue().doubleValue() / that.doubleValue(), this.getUnit());
    }

    public Quantity<Q> inverse() {
        return NumberQuantity.of(1.0 / this.value.doubleValue(), this.getUnit().inverse());
    }

    public Quantity<Q> subtract(Quantity<Q> that) {
        Quantity thatToUnit = that.to(this.getUnit());
        return new NumberQuantity(this.getValue().doubleValue() - thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    public Quantity<Q> add(Quantity<Q> that) {
        Quantity thatToUnit = that.to(this.getUnit());
        return new NumberQuantity(this.getValue().doubleValue() + thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(long longValue, Unit<Q> unit) {
        return new LongQuantity<Q>(longValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(int intValue, Unit<Q> unit) {
        return new IntegerQuantity<Q>(intValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(short value, Unit<Q> unit) {
        return new ShortQuantity<Q>(value, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(float floatValue, Unit<Q> unit) {
        return new FloatQuantity<Q>(floatValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(double doubleValue, Unit<Q> unit) {
        return new DoubleQuantity<Q>(doubleValue, unit);
    }

    public static Quantity<?> parse(CharSequence csq) {
        return (Quantity)QuantityFormat.getInstance().parse(csq);
    }
}

