/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import org.eclipse.uomo.core.impl.OutputHelper;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractQuantity;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.impl.AlternateUnit;
import org.eclipse.uomo.units.impl.AnnotatedUnit;
import org.eclipse.uomo.units.impl.BaseUnit;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.eclipse.uomo.units.impl.TransformedUnit;
import org.eclipse.uomo.units.impl.converter.RationalConverter;

public class BaseAmount<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private final Number value;
    protected static final BaseAmount<Dimensionless> ONE = new BaseAmount<Dimensionless>(BigDecimal.ONE, AbstractUnit.ONE);

    public BaseAmount(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
    }

    public static <Q extends Quantity<Q>> BaseAmount<Q> valueOf(Number value, Unit<Q> unit) {
        BaseAmount<Q> amount = new BaseAmount<Q>(value, unit);
        return amount;
    }

    public BaseAmount<Q> add(Quantity<Q> that) {
        Quantity thatToUnit = that.to(this.getUnit());
        return new BaseAmount(this.getValue().doubleValue() + thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    public BaseAmount<Q> subtract(Quantity<Q> that) {
        Quantity thatToUnit = that.to(this.getUnit());
        return new BaseAmount(this.getValue().doubleValue() - thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    public BaseAmount<Q> multiply(Quantity<?> that) {
        Unit unit = this.getUnit().multiply(that.getUnit());
        return BaseAmount.valueOf(this.getValue().doubleValue() * that.getValue().doubleValue(), unit);
    }

    public Quantity<Q> multiply(Number that) {
        return BaseAmount.valueOf(this.getValue().doubleValue() * that.doubleValue(), this.getUnit());
    }

    public BaseAmount<Q> divide(Quantity<?> that) {
        Unit unit = this.getUnit().divide(that.getUnit());
        return BaseAmount.valueOf(this.getValue().doubleValue() / that.getValue().doubleValue(), unit);
    }

    @Override
    public BaseAmount<Q> to(Unit<Q> unit) {
        return this.to(unit, MathContext.DECIMAL128);
    }

    public BaseAmount<Q> to(Unit<Q> unit, MathContext ctx) {
        if (this.getUnit().equals(unit)) {
            return this;
        }
        UnitConverter cvtr = this.getUnit().getConverterTo(unit);
        if (cvtr == AbstractConverter.IDENTITY) {
            return BaseAmount.valueOf(this.getValue(), unit);
        }
        return BaseAmount.valueOf(BaseAmount.convert(this.getValue(), cvtr, ctx), unit);
    }

    private static Number convert(Number value, UnitConverter cvtr, MathContext ctx) {
        if (cvtr instanceof RationalConverter) {
            RationalConverter rCvtr = (RationalConverter)cvtr;
            BigInteger dividend = rCvtr.getDividend();
            BigInteger divisor = rCvtr.getDivisor();
            if (dividend.abs().compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new ArithmeticException("Multiplier overflow");
            }
            if (divisor.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new ArithmeticException("Divisor overflow");
            }
            if (value instanceof BigInteger || value instanceof Long || value instanceof Integer) {
                return value.longValue() * dividend.longValue() / divisor.longValue();
            }
            return value.doubleValue() * dividend.doubleValue() / divisor.doubleValue();
        }
        if (cvtr instanceof AbstractConverter.Compound && cvtr.isLinear()) {
            AbstractConverter.Compound compound = (AbstractConverter.Compound)cvtr;
            Number firstConversion = BaseAmount.convert(value, compound.getRight(), ctx);
            Number secondConversion = BaseAmount.convert(firstConversion, compound.getLeft(), ctx);
            return secondConversion;
        }
        BigDecimal decimalValue = BigDecimal.valueOf(value.doubleValue());
        Number newValue = cvtr.convert((Number)decimalValue);
        return newValue;
    }

    public Quantity<? extends Quantity<Q>> pow(int exp) {
        if (exp < 0) {
            return this.pow(-exp).inverse();
        }
        if (exp == 0) {
            return ONE;
        }
        BaseAmount<Q> pow2 = this;
        BaseAmount<Q> result = null;
        while (exp >= 1) {
            if ((exp & 1) == 1) {
                result = result == null ? pow2 : result.multiply(pow2);
            }
            pow2 = pow2.multiply(pow2);
            exp >>>= 1;
        }
        return result;
    }

    public Quantity<? extends Quantity<Q>> inverse() {
        BaseAmount<Q> m = new BaseAmount<Q>(this.getValue(), this.getUnit().inverse());
        return m;
    }

    @Override
    public int compareTo(BaseAmount<Q> o) {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BaseAmount) {
            ProductUnit pu;
            BaseUnit bu;
            AbstractUnit au;
            BaseAmount ba = (BaseAmount)obj;
            if (this.getUnit().getClass() == ba.getUnit().getClass()) {
                return super.equals(obj);
            }
            if (ba.getUnit() instanceof AlternateUnit) {
                AlternateUnit baa = (AlternateUnit)ba.getUnit();
                if (this.getUnit() instanceof AlternateUnit) {
                    return super.equals(obj);
                }
                if (this.getUnit() instanceof AnnotatedUnit) {
                    au = (AnnotatedUnit)this.getUnit();
                    OutputHelper.println((String)("Ann: " + au));
                } else if (this.getUnit() instanceof BaseUnit) {
                    bu = (BaseUnit)this.getUnit();
                    OutputHelper.println((String)("Bas: " + bu));
                } else if (this.getUnit() instanceof ProductUnit) {
                    pu = (ProductUnit)this.getUnit();
                    OutputHelper.println((String)("Pro: " + pu));
                } else if (this.getUnit() instanceof TransformedUnit) {
                    TransformedUnit tu = (TransformedUnit)this.getUnit();
                    OutputHelper.println((String)("Tran: " + tu));
                    if (tu.getParentUnit().equals(baa)) {
                        return true;
                    }
                } else {
                    return super.equals(obj);
                }
            }
            if (ba.getUnit() instanceof BaseUnit) {
                AbstractUnit au2;
                if (this.getUnit() instanceof AlternateUnit) {
                    au2 = (AlternateUnit)this.getUnit();
                    OutputHelper.println((String)("Alt: " + au2));
                } else if (this.getUnit() instanceof AnnotatedUnit) {
                    au2 = (AnnotatedUnit)this.getUnit();
                    OutputHelper.println((String)("Ann: " + au2));
                } else {
                    if (this.getUnit() instanceof BaseUnit) {
                        return super.equals(obj);
                    }
                    if (this.getUnit() instanceof ProductUnit) {
                        ProductUnit pu2 = (ProductUnit)this.getUnit();
                        OutputHelper.println((String)("Pro: " + pu2));
                    } else if (this.getUnit() instanceof TransformedUnit) {
                        TransformedUnit tu = (TransformedUnit)this.getUnit();
                        OutputHelper.println((String)("Tran: " + tu));
                    } else {
                        return super.equals(obj);
                    }
                }
            }
            if (ba.getUnit() instanceof TransformedUnit) {
                TransformedUnit bat = (TransformedUnit)ba.getUnit();
                if (this.getUnit() instanceof AlternateUnit) {
                    au = (AlternateUnit)this.getUnit();
                    OutputHelper.println((String)("Alt: " + au));
                    if (bat.getParentUnit().equals(au)) {
                        return true;
                    }
                } else if (this.getUnit() instanceof AnnotatedUnit) {
                    au = (AnnotatedUnit)this.getUnit();
                    System.out.println("Ann: " + au);
                } else if (this.getUnit() instanceof BaseUnit) {
                    bu = (BaseUnit)this.getUnit();
                    OutputHelper.println((String)("Bas: " + bu));
                } else if (this.getUnit() instanceof ProductUnit) {
                    pu = (ProductUnit)this.getUnit();
                    OutputHelper.println((String)("Pro: " + pu));
                } else {
                    if (this.getUnit() instanceof TransformedUnit) {
                        return super.equals(obj);
                    }
                    return super.equals(obj);
                }
            }
        }
        return super.equals(obj);
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public boolean isBig() {
        return this.value instanceof BigDecimal;
    }

    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        BigDecimal decimal = this.getValue() instanceof BigDecimal ? (BigDecimal)this.getValue() : BigDecimal.valueOf(this.getValue().doubleValue());
        return this.getUnit().equals(unit) ? decimal : ((AbstractConverter)this.getUnit().getConverterTo(unit)).convert(decimal, ctx);
    }

    @Override
    public double doubleValue(Unit<Q> unit) throws ArithmeticException {
        return this.getUnit().equals(unit) ? this.getValue().doubleValue() : this.getUnit().getConverterTo(unit).convert(this.getValue().doubleValue());
    }

    public Quantity<Q> divide(Number arg0) {
        return null;
    }
}

