/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.impl.converter.ExpConverter;

public final class LogConverter
extends AbstractConverter {
    private static final long serialVersionUID = -5581266460675123322L;
    private final double base;
    private final double logOfBase;

    public LogConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public AbstractConverter inverse() {
        return new ExpConverter(this.base);
    }

    public final String toString() {
        return "LogConverter(" + this.base + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogConverter)) {
            return false;
        }
        LogConverter that = (LogConverter)obj;
        return this.base == that.base;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.base);
        return (int)(bits ^ bits >>> 32);
    }

    public double convert(double amount) {
        return Math.log(amount) / this.logOfBase;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    public Number convert(Number value) {
        if (value instanceof BigDecimal) {
            return this.convert((BigDecimal)value, MathContext.DECIMAL128);
        }
        return this.convert(value.doubleValue());
    }

    public boolean isLinear() {
        return false;
    }
}

