/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.impl.converter.PiMultiplierConverter;
import tec.uom.lib.common.function.ValueSupplier;

final class PiDivisorConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = 5052794216568914141L;

    public double convert(double value) {
        return value / Math.PI;
    }

    public Number convert(Number value) {
        if (value instanceof BigDecimal) {
            return this.convert((BigDecimal)value, MathContext.DECIMAL128);
        }
        return this.convert(value.doubleValue());
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        int nbrDigits = ctx.getPrecision();
        if (nbrDigits == 0) {
            throw new ArithmeticException("Pi multiplication with unlimited precision");
        }
        BigDecimal pi = PiMultiplierConverter.Pi.pi(nbrDigits);
        return value.divide(pi, ctx).scaleByPowerOfTen(nbrDigits - 1);
    }

    @Override
    public UnitConverter inverse() {
        return new PiMultiplierConverter();
    }

    public final String toString() {
        return "(1/\u03c0)";
    }

    public boolean equals(Object obj) {
        return obj instanceof PiDivisorConverter;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isLinear() {
        return true;
    }

    public String getValue() {
        return this.toString();
    }
}

