/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.AbstractUnitFormat;
import org.eclipse.uomo.units.SymbolMap;
import org.eclipse.uomo.units.impl.AlternateUnit;
import org.eclipse.uomo.units.impl.BaseUnit;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.eclipse.uomo.units.impl.TransformedUnit;
import org.eclipse.uomo.units.impl.converter.AddConverter;
import org.eclipse.uomo.units.impl.converter.MultiplyConverter;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.eclipse.uomo.units.impl.system.MetricPrefix;
import org.eclipse.uomo.units.impl.system.Units;

public abstract class SimpleUnitFormat
extends AbstractUnitFormat {
    private static final DefaultFormat DEFAULT = new DefaultFormat();
    private static final ASCIIFormat ASCII = new ASCIIFormat();
    private static final Map<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();
    private static final Unit<?>[] SI_UNITS = new Unit[]{Units.AMPERE, Units.BECQUEREL, Units.CANDELA, Units.COULOMB, Units.FARAD, Units.GRAY, Units.HENRY, Units.HERTZ, Units.JOULE, Units.KATAL, Units.KELVIN, Units.LUMEN, Units.LUX, Units.METRE, Units.MOLE, Units.NEWTON, Units.OHM, Units.PASCAL, Units.RADIAN, Units.SECOND, Units.SIEMENS, Units.SIEVERT, Units.STERADIAN, Units.TESLA, Units.VOLT, Units.WATT, Units.WEBER};
    private static final String[] PREFIXES = new String[]{MetricPrefix.YOTTA.getSymbol(), MetricPrefix.ZETTA.getSymbol(), MetricPrefix.EXA.getSymbol(), MetricPrefix.PETA.getSymbol(), MetricPrefix.TERA.getSymbol(), MetricPrefix.GIGA.getSymbol(), MetricPrefix.MEGA.getSymbol(), MetricPrefix.KILO.getSymbol(), MetricPrefix.HECTO.getSymbol(), MetricPrefix.DEKA.getSymbol(), MetricPrefix.DECI.getSymbol(), MetricPrefix.CENTI.getSymbol(), MetricPrefix.MILLI.getSymbol(), MetricPrefix.MICRO.getSymbol(), MetricPrefix.NANO.getSymbol(), MetricPrefix.PICO.getSymbol(), MetricPrefix.FEMTO.getSymbol(), MetricPrefix.ATTO.getSymbol(), MetricPrefix.ZEPTO.getSymbol(), MetricPrefix.YOCTO.getSymbol()};
    private static final UnitConverter[] CONVERTERS = new UnitConverter[]{MetricPrefix.YOTTA.getConverter(), MetricPrefix.ZETTA.getConverter(), MetricPrefix.EXA.getConverter(), MetricPrefix.PETA.getConverter(), MetricPrefix.TERA.getConverter(), MetricPrefix.GIGA.getConverter(), MetricPrefix.MEGA.getConverter(), MetricPrefix.KILO.getConverter(), MetricPrefix.HECTO.getConverter(), MetricPrefix.DEKA.getConverter(), MetricPrefix.DECI.getConverter(), MetricPrefix.CENTI.getConverter(), MetricPrefix.MILLI.getConverter(), MetricPrefix.MICRO.getConverter(), MetricPrefix.NANO.getConverter(), MetricPrefix.PICO.getConverter(), MetricPrefix.FEMTO.getConverter(), MetricPrefix.ATTO.getConverter(), MetricPrefix.ZEPTO.getConverter(), MetricPrefix.YOCTO.getConverter()};

    static {
        int i = 0;
        while (i < SI_UNITS.length) {
            Unit<?> si = SI_UNITS[i];
            String symbol = si instanceof BaseUnit ? ((BaseUnit)si).getSymbol() : ((AlternateUnit)si).getSymbol();
            DEFAULT.label(si, symbol);
            if (SimpleUnitFormat.isAllASCII(symbol)) {
                ASCII.label(si, symbol);
            }
            int j = 0;
            while (j < PREFIXES.length) {
                Unit u = si.transform(CONVERTERS[j]);
                DEFAULT.label(u, String.valueOf(PREFIXES[j]) + symbol);
                if (PREFIXES[j] == "\u00b5") {
                    ASCII.label(u, "micro");
                }
                ++j;
            }
            ++i;
        }
        DEFAULT.label(Units.GRAM, "g");
        i = 0;
        while (i < PREFIXES.length) {
            if (CONVERTERS[i] != MetricPrefix.KILO.getConverter()) {
                DEFAULT.label(Units.KILOGRAM.transform(CONVERTERS[i].concatenate(MetricPrefix.MILLI.getConverter())), String.valueOf(PREFIXES[i]) + "g");
                if (PREFIXES[i] == "\u00b5") {
                    ASCII.label(Units.KILOGRAM.transform(CONVERTERS[i].concatenate(MetricPrefix.MILLI.getConverter())), "microg");
                }
            }
            ++i;
        }
        DEFAULT.alias(Units.OHM, "Ohm");
        ASCII.label(Units.OHM, "Ohm");
        i = 0;
        while (i < PREFIXES.length) {
            DEFAULT.alias(Units.OHM.transform(CONVERTERS[i]), String.valueOf(PREFIXES[i]) + "Ohm");
            ASCII.label(Units.OHM.transform(CONVERTERS[i]), String.valueOf(SimpleUnitFormat.asciiPrefix(PREFIXES[i])) + "Ohm");
            ++i;
        }
        DEFAULT.label(Units.CELSIUS, "\u00b0C");
        DEFAULT.alias(Units.CELSIUS, "\u2103");
        ASCII.label(Units.CELSIUS, "Celsius");
        i = 0;
        while (i < PREFIXES.length) {
            DEFAULT.label(Units.CELSIUS.transform(CONVERTERS[i]), String.valueOf(PREFIXES[i]) + "\u2103");
            DEFAULT.alias(Units.CELSIUS.transform(CONVERTERS[i]), String.valueOf(PREFIXES[i]) + "\u00b0C");
            ASCII.label(Units.CELSIUS.transform(CONVERTERS[i]), String.valueOf(SimpleUnitFormat.asciiPrefix(PREFIXES[i])) + "Celsius");
            ++i;
        }
        DEFAULT.label(Units.PERCENT, "%");
        DEFAULT.label(Units.KILOGRAM, "kg");
        DEFAULT.label(Units.METRE, "m");
        DEFAULT.label(Units.SECOND, "s");
        DEFAULT.label(Units.MINUTE, "min");
        DEFAULT.label(Units.HOUR, "h");
        DEFAULT.label(Units.DAY, "day");
        DEFAULT.label(Units.WEEK, "week");
        DEFAULT.label(Units.YEAR, "year");
        DEFAULT.label(Units.KILOMETRE_PER_HOUR, "km/h");
        DEFAULT.label(Units.CUBIC_METRE, "\u33a5");
        ASCII.label(Units.CUBIC_METRE, "m3");
        ASCII.label(Units.LITRE, "l");
        DEFAULT.label(Units.LITRE, "l");
        DEFAULT.label(MetricPrefix.NANO(Units.LITRE), "nl");
        ASCII.label(MetricPrefix.NANO(Units.LITRE), "nl");
        DEFAULT.label(MetricPrefix.MICRO(Units.LITRE), "\u00b5l");
        ASCII.label(MetricPrefix.MICRO(Units.LITRE), "microL");
        ASCII.label(MetricPrefix.MILLI(Units.LITRE), "mL");
        DEFAULT.label(MetricPrefix.MILLI(Units.LITRE), "ml");
        ASCII.label(MetricPrefix.CENTI(Units.LITRE), "cL");
        DEFAULT.label(MetricPrefix.CENTI(Units.LITRE), "cl");
        ASCII.label(MetricPrefix.DECI(Units.LITRE), "dL");
        DEFAULT.label(MetricPrefix.DECI(Units.LITRE), "dl");
        DEFAULT.label(Units.NEWTON, "N");
        ASCII.label(Units.NEWTON, "N");
        DEFAULT.label(Units.RADIAN, "rad");
        ASCII.label(Units.RADIAN, "rad");
    }

    public static SimpleUnitFormat getInstance() {
        return SimpleUnitFormat.getInstance(Flavor.Default);
    }

    public static SimpleUnitFormat getInstance(Flavor flavor) {
        switch (flavor) {
            case ASCII: {
                return ASCII;
            }
        }
        return DEFAULT;
    }

    protected SimpleUnitFormat() {
    }

    @Override
    public abstract Appendable format(Unit<?> var1, Appendable var2) throws IOException;

    public abstract Unit<? extends Quantity> parseProductUnit(CharSequence var1, ParsePosition var2) throws ParserException;

    public abstract Unit<? extends Quantity> parseSingleUnit(CharSequence var1, ParsePosition var2) throws ParserException;

    public abstract void label(Unit<?> var1, String var2);

    public boolean isLocaleSensitive() {
        return false;
    }

    public abstract void alias(Unit<?> var1, String var2);

    public abstract boolean isValidIdentifier(String var1);

    @Override
    public final StringBuffer format(Object unit, final StringBuffer toAppendTo, FieldPosition pos) {
        try {
            StringBuffer dest = toAppendTo;
            if (dest instanceof Appendable) {
                this.format((Unit)unit, dest);
            } else {
                this.format((Unit)unit, new Appendable(){

                    @Override
                    public Appendable append(char arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0, int arg1, int arg2) throws IOException {
                        toAppendTo.append(arg0.subSequence(arg1, arg2));
                        return null;
                    }
                });
            }
            return toAppendTo;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public final Unit<?> parseObject(String source, ParsePosition pos) throws ParserException {
        return this.parseProductUnit(source, pos);
    }

    private static String asciiPrefix(String prefix) {
        return prefix == "\u00b5" ? "micro" : prefix;
    }

    protected static boolean isAllASCII(String input) {
        boolean isASCII = true;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c > '\u007f') {
                isASCII = false;
                break;
            }
            ++i;
        }
        return isASCII;
    }

    protected static final class ASCIIFormat
    extends DefaultFormat {
        protected ASCIIFormat() {
        }

        @Override
        protected String nameFor(Unit<?> unit) {
            String name = (String)this._unitToName.get(unit);
            if (name != null) {
                return name;
            }
            return DEFAULT.nameFor(unit);
        }

        @Override
        protected Unit<?> unitFor(String name) {
            Unit unit = (Unit)this._nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            return DEFAULT.unitFor(name);
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            int i = 0;
            while (i < productUnit.getUnitCount()) {
                if (i != 0) {
                    appendable.append('*');
                }
                name = this.nameFor(productUnit.getUnit(i));
                int pow = productUnit.getUnitPow(i);
                int root = productUnit.getUnitRoot(i);
                appendable.append(name);
                if (pow != 1 || root != 1) {
                    appendable.append('^');
                    appendable.append(String.valueOf(pow));
                    if (root != 1) {
                        appendable.append(':');
                        appendable.append(String.valueOf(root));
                    }
                }
                ++i;
            }
            return appendable;
        }

        @Override
        public boolean isValidIdentifier(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return ASCIIFormat.isUnitIdentifierPart(name.charAt(0)) && ASCIIFormat.isAllASCII(name);
        }
    }

    protected static class DefaultFormat
    extends SimpleUnitFormat {
        final HashMap<String, Unit<?>> _nameToUnit = new HashMap();
        final HashMap<Unit<?>, String> _unitToName = new HashMap();
        private static final int EOF = 0;
        private static final int IDENTIFIER = 1;
        private static final int OPEN_PAREN = 2;
        private static final int CLOSE_PAREN = 3;
        private static final int EXPONENT = 4;
        private static final int MULTIPLY = 5;
        private static final int DIVIDE = 6;
        private static final int PLUS = 7;
        private static final int INTEGER = 8;
        private static final int FLOAT = 9;

        protected DefaultFormat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void label(Unit<?> unit, String label) {
            if (!this.isValidIdentifier(label)) {
                throw new IllegalArgumentException("Label: " + label + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this._nameToUnit.put(label, unit);
                this._unitToName.put(unit, label);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alias(Unit<?> unit, String alias) {
            if (!this.isValidIdentifier(alias)) {
                throw new IllegalArgumentException("Alias: " + alias + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this._nameToUnit.put(alias, unit);
            }
        }

        @Override
        public boolean isValidIdentifier(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            return DefaultFormat.isUnitIdentifierPart(name.charAt(0));
        }

        static boolean isUnitIdentifierPart(char ch) {
            return Character.isLetter(ch) || !Character.isWhitespace(ch) && !Character.isDigit(ch) && ch != '\u00b7' && ch != '*' && ch != '/' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '\u00b9' && ch != '\u00b2' && ch != '\u00b3' && ch != '^' && ch != '+' && ch != '-';
        }

        protected String nameFor(Unit<?> unit) {
            String label = this._unitToName.get(unit);
            if (label != null) {
                return label;
            }
            if (unit instanceof BaseUnit) {
                return ((BaseUnit)unit).getSymbol();
            }
            if (unit instanceof AlternateUnit) {
                return ((AlternateUnit)unit).getSymbol();
            }
            if (unit instanceof TransformedUnit) {
                TransformedUnit tfmUnit = (TransformedUnit)unit;
                Unit baseUnit = tfmUnit.getParentUnit();
                UnitConverter cvtr = tfmUnit.getConverterToMetric();
                StringBuilder result = new StringBuilder();
                String baseUnitName = baseUnit.toString();
                String prefix = this.prefixFor(cvtr);
                if (baseUnitName.indexOf(183) >= 0 || baseUnitName.indexOf(42) >= 0 || baseUnitName.indexOf(47) >= 0) {
                    result.append('(');
                    result.append(baseUnitName);
                    result.append(')');
                } else {
                    result.append(baseUnitName);
                }
                if (prefix != null) {
                    result.insert(0, prefix);
                } else if (cvtr instanceof AddConverter) {
                    result.append('+');
                    result.append(((AddConverter)cvtr).getOffset());
                } else if (cvtr instanceof RationalConverter) {
                    double divisor;
                    double dividend = ((RationalConverter)cvtr).getDividend().doubleValue();
                    if (dividend != 1.0) {
                        result.append('*');
                        result.append(dividend);
                    }
                    if ((divisor = ((RationalConverter)cvtr).getDivisor().doubleValue()) != 1.0) {
                        result.append('/');
                        result.append(divisor);
                    }
                } else if (cvtr instanceof MultiplyConverter) {
                    result.append('*');
                    result.append(((MultiplyConverter)cvtr).getFactor());
                } else {
                    return "[" + baseUnit + "?]";
                }
                return result.toString();
            }
            return null;
        }

        protected String prefixFor(UnitConverter converter) {
            int i = 0;
            while (i < CONVERTERS.length) {
                if (CONVERTERS[i].equals(converter)) {
                    return PREFIXES[i];
                }
                ++i;
            }
            return null;
        }

        protected Unit<?> unitFor(String name) {
            Unit unit = this._nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            unit = (Unit)SYMBOL_TO_UNIT.get(name);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseSingleUnit(CharSequence csq, ParsePosition pos) throws ParserException {
            int startIndex = pos.getIndex();
            String name = this.readIdentifier(csq, pos);
            Unit<?> unit = this.unitFor(name);
            this.check(unit != null, String.valueOf(name) + " not recognized", csq, startIndex);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseProductUnit(CharSequence csq, ParsePosition pos) throws ParserException {
            Unit result = AbstractUnit.ONE;
            int token = this.nextToken(csq, pos);
            switch (token) {
                case 1: {
                    result = this.parseSingleUnit(csq, pos);
                    break;
                }
                case 2: {
                    pos.setIndex(pos.getIndex() + 1);
                    result = this.parseProductUnit(csq, pos);
                    token = this.nextToken(csq, pos);
                    this.check(token == 3, "')' expected", csq, pos.getIndex());
                    pos.setIndex(pos.getIndex() + 1);
                }
            }
            token = this.nextToken(csq, pos);
            while (true) {
                switch (token) {
                    case 4: {
                        Exponent e = this.readExponent(csq, pos);
                        if (e.pow != 1) {
                            result = result.pow(e.pow);
                        }
                        if (e.root == 1) break;
                        result = result.root(e.root);
                        break;
                    }
                    case 5: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = this.nextToken(csq, pos);
                        if (token == 8) {
                            long n = this.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.multiply((double)n);
                            break;
                        }
                        if (token == 9) {
                            double d = this.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.multiply(d);
                            break;
                        }
                        result = result.multiply(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case 6: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = this.nextToken(csq, pos);
                        if (token == 8) {
                            long n = this.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.divide((double)n);
                            break;
                        }
                        if (token == 9) {
                            double d = this.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.divide(d);
                            break;
                        }
                        result = result.divide(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case 7: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = this.nextToken(csq, pos);
                        if (token == 8) {
                            long n = this.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.shift((double)n);
                            break;
                        }
                        if (token == 9) {
                            double d = this.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.shift(d);
                            break;
                        }
                        throw new ParserException((CharSequence)"not a number", pos.getIndex());
                    }
                    case 0: 
                    case 3: {
                        return result;
                    }
                    default: {
                        throw new ParserException((CharSequence)("unexpected token " + token), pos.getIndex());
                    }
                }
                token = this.nextToken(csq, pos);
            }
        }

        private int nextToken(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            while (pos.getIndex() < length) {
                char c = csq.charAt(pos.getIndex());
                if (DefaultFormat.isUnitIdentifierPart(c)) {
                    return 1;
                }
                if (c == '(') {
                    return 2;
                }
                if (c == ')') {
                    return 3;
                }
                if (c == '^' || c == '\u00b9' || c == '\u00b2' || c == '\u00b3') {
                    return 4;
                }
                if (c == '*') {
                    char c2 = csq.charAt(pos.getIndex() + 1);
                    if (c2 == '*') {
                        return 4;
                    }
                    return 5;
                }
                if (c == '\u00b7') {
                    return 5;
                }
                if (c == '/') {
                    return 6;
                }
                if (c == '+') {
                    return 7;
                }
                if (c == '-' || Character.isDigit(c)) {
                    int index = pos.getIndex() + 1;
                    while (index < length && (Character.isDigit(c) || c == '-' || c == '.' || c == 'E')) {
                        if ((c = csq.charAt(index++)) != '.') continue;
                        return 9;
                    }
                    return 8;
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return 0;
        }

        private void check(boolean expr, String message, CharSequence csq, int index) throws ParserException {
            if (!expr) {
                throw new ParserException((CharSequence)(String.valueOf(message) + " (in " + csq + " at index " + index + ")"), index);
            }
        }

        private Exponent readExponent(CharSequence csq, ParsePosition pos) {
            char c = csq.charAt(pos.getIndex());
            if (c == '^') {
                pos.setIndex(pos.getIndex() + 1);
            } else if (c == '*') {
                pos.setIndex(pos.getIndex() + 2);
            }
            int length = csq.length();
            int pow = 0;
            boolean isPowNegative = false;
            int root = 0;
            boolean isRootNegative = false;
            boolean isRoot = false;
            while (pos.getIndex() < length) {
                c = csq.charAt(pos.getIndex());
                if (c == '\u00b9') {
                    if (isRoot) {
                        root = root * 10 + 1;
                    } else {
                        pow = pow * 10 + 1;
                    }
                } else if (c == '\u00b2') {
                    if (isRoot) {
                        root = root * 10 + 2;
                    } else {
                        pow = pow * 10 + 2;
                    }
                } else if (c == '\u00b3') {
                    if (isRoot) {
                        root = root * 10 + 3;
                    } else {
                        pow = pow * 10 + 3;
                    }
                } else if (c == '-') {
                    if (isRoot) {
                        isRootNegative = true;
                    } else {
                        isPowNegative = true;
                    }
                } else if (c >= '0' && c <= '9') {
                    if (isRoot) {
                        root = root * 10 + (c - 48);
                    } else {
                        pow = pow * 10 + (c - 48);
                    }
                } else {
                    if (c != ':') break;
                    isRoot = true;
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            if (pow == 0) {
                pow = 1;
            }
            if (root == 0) {
                root = 1;
            }
            return new Exponent(isPowNegative ? -pow : pow, isRootNegative ? -root : root);
        }

        private long readLong(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            int result = 0;
            boolean isNegative = false;
            while (pos.getIndex() < length) {
                char c = csq.charAt(pos.getIndex());
                if (c == '-') {
                    isNegative = true;
                } else {
                    if (c < '0' || c > '9') break;
                    result = result * 10 + (c - 48);
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return isNegative ? -result : result;
        }

        private double readDouble(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            int start = pos.getIndex();
            int end = start + 1;
            while (end < length) {
                if ("0123456789+-.E".indexOf(csq.charAt(end)) < 0) break;
                ++end;
            }
            pos.setIndex(end + 1);
            return Double.parseDouble(csq.subSequence(start, end).toString());
        }

        private String readIdentifier(CharSequence csq, ParsePosition pos) {
            int start;
            int length = csq.length();
            int i = start = pos.getIndex();
            while (++i < length && DefaultFormat.isUnitIdentifierPart(csq.charAt(i))) {
            }
            pos.setIndex(i);
            return csq.subSequence(start, i).toString();
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            int root;
            int pow;
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            int invNbr = 0;
            boolean start = true;
            int i = 0;
            while (i < productUnit.getUnitCount()) {
                pow = productUnit.getUnitPow(i);
                if (pow >= 0) {
                    if (!start) {
                        appendable.append('\u00b7');
                    }
                    name = this.nameFor(productUnit.getUnit(i));
                    root = productUnit.getUnitRoot(i);
                    this.append(appendable, name, pow, root);
                    start = false;
                } else {
                    ++invNbr;
                }
                ++i;
            }
            if (invNbr != 0) {
                if (start) {
                    appendable.append('1');
                }
                appendable.append('/');
                if (invNbr > 1) {
                    appendable.append('(');
                }
                start = true;
                i = 0;
                while (i < productUnit.getUnitCount()) {
                    pow = productUnit.getUnitPow(i);
                    if (pow < 0) {
                        name = this.nameFor(productUnit.getUnit(i));
                        root = productUnit.getUnitRoot(i);
                        if (!start) {
                            appendable.append('\u00b7');
                        }
                        this.append(appendable, name, -pow, root);
                        start = false;
                    }
                    ++i;
                }
                if (invNbr > 1) {
                    appendable.append(')');
                }
            }
            return appendable;
        }

        private void append(Appendable appendable, CharSequence symbol, int pow, int root) throws IOException {
            appendable.append(symbol);
            if (pow != 1 || root != 1) {
                if (pow == 2 && root == 1) {
                    appendable.append('\u00b2');
                } else if (pow == 3 && root == 1) {
                    appendable.append('\u00b3');
                } else {
                    appendable.append('^');
                    appendable.append(String.valueOf(pow));
                    if (root != 1) {
                        appendable.append(':');
                        appendable.append(String.valueOf(root));
                    }
                }
            }
        }

        public Unit<?> parse(CharSequence csq) throws ParserException {
            return this.parse(csq, 0);
        }

        protected Unit<?> parse(CharSequence csq, int index) throws ParserException {
            return this.parseObject(csq.toString(), new ParsePosition(index));
        }

        @Override
        protected SymbolMap getSymbolMap() {
            return null;
        }

        @Override
        public Unit<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
            return null;
        }
    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }

    public static enum Flavor {
        Default,
        ASCII;

    }
}

