/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.xml.impl;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.uomo.xml.impl.XMLWriterState;

class XMLWriterStateStack {
    private Vector<XMLWriterState> items = new Vector();

    XMLWriterStateStack() {
    }

    public int size() {
        return this.items.size();
    }

    public boolean empty() {
        return this.items.size() == 0;
    }

    public XMLWriterState current() throws IOException {
        if (this.empty()) {
            throw new IOException("stack is empty trying to get current");
        }
        return this.items.get(this.items.size() - 1);
    }

    public void push(XMLWriterState element) {
        this.items.add(element);
    }

    public void clear() {
        if (this.items != null) {
            this.items.clear();
        }
    }

    public void pop() throws IOException {
        if (this.empty()) {
            throw new IOException("stack is empty trying to pop");
        }
        if (this.current().isInComment()) {
            throw new IOException("Must close a comment sequence in the element in which it was started");
        }
        this.items.remove(this.items.size() - 1);
    }

    public XMLWriterState item(int index) {
        return this.items.get(index);
    }

    public boolean inComment() {
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).isInComment()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

