/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.system;

import java.math.BigInteger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.uomo.units.AbstractSystemOfUnits;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.Messages;
import org.eclipse.uomo.units.impl.AlternateUnit;
import org.eclipse.uomo.units.impl.BaseUnit;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.eclipse.uomo.units.impl.TransformedUnit;
import org.eclipse.uomo.units.impl.converter.RationalConverter;

public final class SI
extends AbstractSystemOfUnits {
    private static final SI INSTANCE = new SI();
    public static final Unit<ElectricCurrent> AMPERE = SI.addUnit(new BaseUnit(Messages.SI_A));
    public static final Unit<LuminousIntensity> CANDELA = SI.addUnit(new BaseUnit(Messages.SI_cd));
    public static final Unit<Temperature> KELVIN = SI.addUnit(new BaseUnit(Messages.SI_K));
    public static final Unit<Mass> KILOGRAM = SI.addUnit(new BaseUnit(Messages.SI_kg, Messages.SI_kg_name));
    public static final Unit<Length> METRE = SI.addUnit(new BaseUnit(Messages.SI_m, Messages.SI_m_name));
    public static final Unit<AmountOfSubstance> MOLE = SI.addUnit(new BaseUnit(Messages.SI_mol));
    public static final Unit<Time> SECOND = SI.addUnit(new BaseUnit(Messages.SI_s));
    public static final Unit<Mass> GRAM = KILOGRAM.divide(1000.0);
    public static final Unit<Angle> RADIAN = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, Messages.SI_rad));
    public static final Unit<SolidAngle> STERADIAN = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, Messages.SI_sr));
    public static final Unit<Frequency> HERTZ = SI.addUnit(new AlternateUnit((AbstractUnit)AbstractUnit.ONE.divide(SECOND), Messages.SI_Hz));
    public static final Unit<Force> NEWTON = SI.addUnit(new AlternateUnit((AbstractUnit)METRE.multiply(KILOGRAM).divide(SECOND.pow(2)), Messages.SI_N));
    public static final Unit<Pressure> PASCAL = SI.addUnit(new AlternateUnit((AbstractUnit)NEWTON.divide(METRE.pow(2)), Messages.SI_Pa));
    public static final Unit<Energy> JOULE = SI.addUnit(new AlternateUnit((AbstractUnit)NEWTON.multiply(METRE), Messages.SI_J));
    public static final Unit<Power> WATT = SI.addUnit(new AlternateUnit((AbstractUnit)JOULE.divide(SECOND), Messages.SI_W));
    public static final Unit<ElectricCharge> COULOMB = SI.addUnit(new AlternateUnit((AbstractUnit)SECOND.multiply(AMPERE), Messages.SI_C));
    public static final Unit<ElectricPotential> VOLT = SI.addUnit(new AlternateUnit((AbstractUnit)WATT.divide(AMPERE), Messages.SI_V));
    public static final Unit<ElectricCapacitance> FARAD = SI.addUnit(new AlternateUnit((AbstractUnit)COULOMB.divide(VOLT), Messages.SI_F));
    public static final Unit<ElectricResistance> OHM = SI.addUnit(new AlternateUnit((AbstractUnit)VOLT.divide(AMPERE), Messages.SI_OhmS));
    public static final Unit<ElectricConductance> SIEMENS = SI.addUnit(new AlternateUnit((AbstractUnit)AMPERE.divide(VOLT), Messages.SI_S));
    public static final Unit<MagneticFlux> WEBER = SI.addUnit(new AlternateUnit((AbstractUnit)VOLT.multiply(SECOND), Messages.SI_Wb));
    public static final Unit<MagneticFluxDensity> TESLA = SI.addUnit(new AlternateUnit((AbstractUnit)WEBER.divide(METRE.pow(2)), Messages.SI_T));
    public static final Unit<ElectricInductance> HENRY = SI.addUnit(new AlternateUnit((AbstractUnit)WEBER.divide(AMPERE), Messages.SI_H));
    public static final Unit<Temperature> CELSIUS = SI.addUnit(KELVIN.shift(273.15));
    public static final Unit<LuminousFlux> LUMEN = SI.addUnit(new AlternateUnit((AbstractUnit)CANDELA.multiply(STERADIAN), Messages.SI_lm));
    public static final Unit<Illuminance> LUX = SI.addUnit(new AlternateUnit((AbstractUnit)LUMEN.divide(METRE.pow(2)), Messages.SI_lx));
    public static final Unit<Radioactivity> BECQUEREL = SI.addUnit(new AlternateUnit((AbstractUnit)AbstractUnit.ONE.divide(SECOND), Messages.SI_Bq));
    public static final Unit<RadiationDoseAbsorbed> GRAY = SI.addUnit(new AlternateUnit((AbstractUnit)JOULE.divide(KILOGRAM), Messages.SI_Gy));
    public static final Unit<RadiationDoseEffective> SIEVERT = SI.addUnit(new AlternateUnit((AbstractUnit)JOULE.divide(KILOGRAM), Messages.SI_Sv));
    public static final Unit<CatalyticActivity> KATAL = SI.addUnit(new AlternateUnit((AbstractUnit)MOLE.divide(SECOND), Messages.SI_kat));
    public static final Unit<Speed> METRES_PER_SECOND = SI.addUnit(new ProductUnit((AbstractUnit)METRE.divide(SECOND)));
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit((AbstractUnit)METRES_PER_SECOND.divide(SECOND)));
    public static final Unit<Area> SQUARE_METRE = SI.addUnit(new ProductUnit((AbstractUnit)METRE.multiply(METRE)));
    public static final Unit<Volume> CUBIC_METRE = SI.addUnit(new ProductUnit((AbstractUnit)SQUARE_METRE.multiply(METRE)));
    public static final TransformedUnit<Dimensionless> PERCENT = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, new RationalConverter(1L, 100L));

    public static final SystemOfUnits getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public static class Prefix {
        private static final RationalConverter E24 = new RationalConverter(BigInteger.TEN.pow(24), BigInteger.ONE);
        private static final RationalConverter E21 = new RationalConverter(BigInteger.TEN.pow(21), BigInteger.ONE);
        private static final RationalConverter E18 = new RationalConverter(BigInteger.TEN.pow(18), BigInteger.ONE);
        private static final RationalConverter E15 = new RationalConverter(BigInteger.TEN.pow(15), BigInteger.ONE);
        private static final RationalConverter E12 = new RationalConverter(BigInteger.TEN.pow(12), BigInteger.ONE);
        private static final RationalConverter E9 = new RationalConverter(BigInteger.TEN.pow(9), BigInteger.ONE);
        private static final RationalConverter E6 = new RationalConverter(BigInteger.TEN.pow(6), BigInteger.ONE);
        private static final RationalConverter E3 = new RationalConverter(BigInteger.TEN.pow(3), BigInteger.ONE);
        private static final RationalConverter E2 = new RationalConverter(BigInteger.TEN.pow(2), BigInteger.ONE);
        private static final RationalConverter E1 = new RationalConverter(BigInteger.TEN.pow(1), BigInteger.ONE);
        private static final RationalConverter Em1 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(1));
        private static final RationalConverter Em2 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(2));
        private static final RationalConverter Em3 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(3));
        private static final RationalConverter Em6 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(6));
        private static final RationalConverter Em9 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(9));
        private static final RationalConverter Em12 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(12));
        private static final RationalConverter Em15 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(15));
        private static final RationalConverter Em18 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(18));
        private static final RationalConverter Em21 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(21));
        private static final RationalConverter Em24 = new RationalConverter(BigInteger.ONE, BigInteger.TEN.pow(24));

        private Prefix() {
        }

        public static <Q extends Quantity<Q>> Unit<Q> YOTTA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E24);
        }

        public static <Q extends Quantity<Q>> Unit<Q> ZETTA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E21);
        }

        public static <Q extends Quantity<Q>> Unit<Q> EXA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E18);
        }

        public static <Q extends Quantity<Q>> Unit<Q> PETA(Unit<Q> unit) {
            return (AbstractUnit)unit.transform((UnitConverter)E15);
        }

        public static <Q extends Quantity<Q>> Unit<Q> TERA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E12);
        }

        public static <Q extends Quantity<Q>> Unit<Q> GIGA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E9);
        }

        public static <Q extends Quantity<Q>> Unit<Q> MEGA(Unit<Q> unit) {
            return unit.transform((UnitConverter)E6);
        }

        public static <Q extends Quantity<Q>> Unit<Q> KILO(Unit<Q> unit) {
            return unit.transform((UnitConverter)E3);
        }

        public static <Q extends Quantity<Q>> Unit<Q> HECTO(AbstractUnit<Q> unit) {
            return unit.transform(E2);
        }

        public static <Q extends Quantity<Q>> Unit<Q> DEKA(AbstractUnit<Q> unit) {
            return unit.transform(E1);
        }

        public static <Q extends Quantity<Q>> Unit<Q> DECI(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em1);
        }

        public static <Q extends Quantity<Q>> Unit<Q> CENTI(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em2);
        }

        public static <Q extends Quantity<Q>> Unit<Q> MILLI(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em3);
        }

        public static <Q extends Quantity<Q>> Unit<Q> MICRO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em6);
        }

        public static <Q extends Quantity<Q>> Unit<Q> NANO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em9);
        }

        public static <Q extends Quantity<Q>> Unit<Q> PICO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em12);
        }

        public static <Q extends Quantity<Q>> Unit<Q> FEMTO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em15);
        }

        public static final <Q extends Quantity<Q>> Unit<Q> ATTO(Unit<Q> unit) {
            return unit.transform((UnitConverter)Em18);
        }

        public static <Q extends Quantity<Q>> Unit<Q> ZEPTO(AbstractUnit<Q> unit) {
            return unit.transform(Em21);
        }

        public static <Q extends Quantity<Q>> Unit<Q> YOCTO(AbstractUnit<Q> unit) {
            return unit.transform(Em24);
        }
    }
}

