/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.impl.DimensionalModel;
import org.eclipse.uomo.units.impl.ProductUnit;
import org.eclipse.uomo.units.impl.QuantityDimension;
import org.eclipse.uomo.units.impl.TransformedUnit;

public class BaseUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements Serializable {
    private final String symbol;
    private final Dimension dimension;
    private static final long serialVersionUID = 1234567654321265167L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseUnit(String symbol, String name) {
        super(name);
        this.symbol = symbol;
        this.dimension = QuantityDimension.NONE;
        HashMap<String, Unit<?>> hashMap = AbstractUnit.SYMBOL_TO_UNIT;
        synchronized (hashMap) {
            Unit<?> unit = AbstractUnit.SYMBOL_TO_UNIT.get(symbol);
            if (unit == null) {
                AbstractUnit.SYMBOL_TO_UNIT.put(symbol, this);
                return;
            }
            if (!(unit instanceof BaseUnit)) {
                throw new IllegalArgumentException("Symbol " + symbol + " is associated to a different unit");
            }
        }
    }

    public BaseUnit(String symbol, Dimension dimension) {
        this.symbol = symbol;
        if (dimension == null) {
            dimension = QuantityDimension.parse(' ');
        }
        this.dimension = dimension;
    }

    public BaseUnit(String symbol) {
        this.symbol = symbol;
        this.dimension = QuantityDimension.NONE;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Unit<Q> getSystemUnit() {
        return this.toMetric();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof BaseUnit)) {
            if (!(that instanceof Unit)) {
                return false;
            }
            if (that instanceof TransformedUnit && ((TransformedUnit)that).getParentUnit() instanceof BaseUnit && this.getSymbol().equals(((TransformedUnit)that).getParentUnit().getSymbol())) {
                for (UnitConverter unitConverter : ((TransformedUnit)that).toParentUnit().getConversionSteps()) {
                }
            }
            if (that instanceof ProductUnit) {
                ProductUnit pu = (ProductUnit)that;
                return this.symbol.equals(pu.getSymbol());
            }
            return false;
        }
        BaseUnit thatUnit = (BaseUnit)that;
        return this.symbol.equals(thatUnit.symbol);
    }

    @Override
    public int hashCode() {
        return this.symbol.hashCode();
    }

    @Override
    protected Unit<Q> toMetric() {
        return this;
    }

    @Override
    public UnitConverter getConverterToMetric() {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public UnitConverter getDimensionalTransform() {
        return DimensionalModel.current().getDimensionalTransform(this.dimension);
    }

    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return null;
    }
}

