/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.eclipse.uomo.units.impl.DoubleQuantity;
import org.eclipse.uomo.units.impl.FloatQuantity;
import org.eclipse.uomo.units.impl.IntegerQuantity;
import org.eclipse.uomo.units.impl.LongQuantity;
import org.eclipse.uomo.units.impl.NumberQuantity;
import org.eclipse.uomo.units.impl.ShortQuantity;
import org.eclipse.uomo.units.impl.format.QuantityFormat;

public final class Quantities {
    private Quantities() {
    }

    public static Quantity<?> getQuantity(CharSequence csq) {
        try {
            return (Quantity)QuantityFormat.getInstance().parse(csq);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ParserException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <Q extends Quantity<Q>> Quantity<Q> getQuantity(Number value, Unit<Q> unit) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (unit == null) {
            throw new NullPointerException();
        }
        if (Double.class.isInstance(value)) {
            return new DoubleQuantity<Q>(value.doubleValue(), unit);
        }
        if (Long.class.isInstance(value)) {
            return new LongQuantity<Q>((Long)Long.class.cast(value), unit);
        }
        if (Short.class.isInstance(value)) {
            return new ShortQuantity<Q>((Short)Short.class.cast(value), unit);
        }
        if (Integer.class.isInstance(value)) {
            return new IntegerQuantity<Q>((Integer)Integer.class.cast(value), unit);
        }
        if (Float.class.isInstance(value)) {
            return new FloatQuantity<Q>(((Float)Float.class.cast(value)).floatValue(), unit);
        }
        return new NumberQuantity<Q>(value, unit);
    }
}

