/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.units.impl.format;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.eclipse.uomo.units.AbstractConverter;
import org.eclipse.uomo.units.AbstractUnit;
import org.eclipse.uomo.units.AbstractUnitFormat;
import org.eclipse.uomo.units.Messages;
import org.eclipse.uomo.units.SymbolMap;
import org.eclipse.uomo.units.impl.AnnotatedUnit;
import org.eclipse.uomo.units.impl.BaseUnit;
import org.eclipse.uomo.units.impl.TransformedUnit;
import org.eclipse.uomo.units.impl.converter.AddConverter;
import org.eclipse.uomo.units.impl.converter.ExpConverter;
import org.eclipse.uomo.units.impl.converter.LogConverter;
import org.eclipse.uomo.units.impl.converter.MultiplyConverter;
import org.eclipse.uomo.units.impl.converter.RationalConverter;
import org.eclipse.uomo.units.impl.format.ParseException;
import org.eclipse.uomo.units.impl.format.ParsePrefix;
import org.eclipse.uomo.units.impl.format.SymbolMapImpl;
import org.eclipse.uomo.units.impl.format.TokenMgrError;
import org.eclipse.uomo.units.impl.format.UnitParser;
import org.eclipse.uomo.units.impl.system.SI;
import org.eclipse.uomo.units.impl.system.USCustomary;

public class LocalUnitFormat
extends AbstractUnitFormat {
    private static final long serialVersionUID = -2046025264383639924L;
    private static final String BUNDLE_NAME = String.valueOf(LocalUnitFormat.class.getPackage().getName()) + ".messages";
    private static final LocalUnitFormat DEFAULT_INSTANCE = new LocalUnitFormat(new SymbolMapImpl(ResourceBundle.getBundle(BUNDLE_NAME)), Locale.getDefault());
    private static final char MIDDLE_DOT = '\u00b7';
    private static final char EXPONENT_1 = '\u00b9';
    private static final char EXPONENT_2 = '\u00b2';
    private static final int ADDITION_PRECEDENCE = 0;
    private static final int PRODUCT_PRECEDENCE = 2;
    private static final int EXPONENT_PRECEDENCE = 4;
    private static final int NOOP_PRECEDENCE = Integer.MAX_VALUE;
    private final Locale uLocale;
    private transient SymbolMapImpl symbolMap;

    public static LocalUnitFormat getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static LocalUnitFormat getInstance(Locale locale) {
        return new LocalUnitFormat(new SymbolMapImpl(ResourceBundle.getBundle(BUNDLE_NAME, locale)), locale);
    }

    protected static LocalUnitFormat getInstance(SymbolMapImpl symbols, Locale locale) {
        return new LocalUnitFormat(symbols, locale);
    }

    public LocalUnitFormat() {
        this(new SymbolMapImpl(ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault())), Locale.getDefault());
    }

    private LocalUnitFormat(SymbolMapImpl symbols, Locale loc) {
        this.symbolMap = symbols;
        this.uLocale = loc;
    }

    @Override
    public SymbolMap getSymbolMap() {
        return this.symbolMap;
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        AnnotatedUnit annotatedUnit;
        this.formatInternal(unit, appendable);
        if (unit instanceof AnnotatedUnit && (annotatedUnit = (AnnotatedUnit)unit).getAnnotation() != null) {
            appendable.append('{');
            appendable.append(annotatedUnit.getAnnotation());
            appendable.append('}');
        }
        return appendable;
    }

    @Override
    public Unit<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
        int start = cursor != null ? cursor.getIndex() : 0;
        int end = csq.length();
        if (end <= start) {
            return AbstractUnit.ONE;
        }
        String source = csq.subSequence(start, end).toString().trim();
        if (source.length() == 0) {
            return AbstractUnit.ONE;
        }
        try {
            UnitParser parser = new UnitParser(this.symbolMap, new StringReader(source));
            Unit<?> result = parser.parseUnit();
            if (cursor != null) {
                cursor.setIndex(end);
            }
            return result;
        }
        catch (ParseException e) {
            if (cursor != null) {
                if (e.currentToken != null) {
                    cursor.setErrorIndex(start + e.currentToken.endColumn);
                } else {
                    cursor.setErrorIndex(start);
                }
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TokenMgrError e) {
            cursor.setErrorIndex(start);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Unit<?> parse(CharSequence csq) {
        return this.parse(csq, new ParsePosition(0));
    }

    private int formatInternal(Unit<?> unit, Appendable buffer) throws IOException {
        String symbol;
        if (unit instanceof AnnotatedUnit) {
            unit = ((AnnotatedUnit)unit).getActualUnit();
        }
        if ((symbol = this.symbolMap.getSymbol(unit)) != null) {
            buffer.append(symbol);
            return Integer.MAX_VALUE;
        }
        if (unit.getBaseUnits() != null) {
            int pow;
            Map productUnits = unit.getBaseUnits();
            int negativeExponentCount = 0;
            boolean start = true;
            for (Map.Entry e : productUnits.entrySet()) {
                pow = (Integer)e.getValue();
                if (pow >= 0) {
                    this.formatExponent((Unit)e.getKey(), pow, 1, !start, buffer);
                    start = false;
                    continue;
                }
                ++negativeExponentCount;
            }
            if (negativeExponentCount > 0) {
                if (start) {
                    buffer.append('1');
                }
                buffer.append('/');
                if (negativeExponentCount > 1) {
                    buffer.append('(');
                }
                start = true;
                for (Map.Entry e : productUnits.entrySet()) {
                    pow = (Integer)e.getValue();
                    if (pow >= 0) continue;
                    this.formatExponent((Unit)e.getKey(), -pow, 1, !start, buffer);
                    start = false;
                }
                if (negativeExponentCount > 1) {
                    buffer.append(')');
                }
            }
            return 2;
        }
        if (unit instanceof BaseUnit) {
            buffer.append(((BaseUnit)unit).getSymbol());
            return Integer.MAX_VALUE;
        }
        if (unit.getSymbol() != null) {
            buffer.append(unit.getSymbol());
            return Integer.MAX_VALUE;
        }
        UnitConverter converter = null;
        boolean printSeparator = false;
        StringBuilder temp = new StringBuilder();
        int unitPrecedence = Integer.MAX_VALUE;
        Object parentUnit = unit.getSystemUnit();
        converter = ((AbstractUnit)unit).getConverterToMetric();
        if (SI.KILOGRAM.equals(parentUnit)) {
            if (unit.equals(SI.GRAM)) {
                buffer.append(this.symbolMap.getSymbol(SI.GRAM));
                return Integer.MAX_VALUE;
            }
            parentUnit = SI.GRAM;
            converter = unit instanceof TransformedUnit ? ((TransformedUnit)unit).toParentUnit() : unit.getConverterTo(SI.GRAM);
        } else if (SI.CUBIC_METRE.equals(parentUnit) && converter != null) {
            parentUnit = USCustomary.LITER;
        }
        if (unit instanceof TransformedUnit) {
            TransformedUnit transUnit = (TransformedUnit)unit;
            if (parentUnit == null) {
                parentUnit = transUnit.getParentUnit();
            }
            converter = transUnit.toParentUnit();
        }
        unitPrecedence = this.formatInternal((Unit<?>)parentUnit, temp);
        printSeparator = !parentUnit.equals(AbstractUnit.ONE);
        int result = this.formatConverter(converter, printSeparator, unitPrecedence, temp);
        buffer.append(temp);
        return result;
    }

    private void formatExponent(Unit<?> unit, int pow, int root, boolean continued, Appendable buffer) throws IOException {
        StringBuilder temp;
        int unitPrecedence;
        if (continued) {
            buffer.append('\u00b7');
        }
        if ((unitPrecedence = this.formatInternal(unit, temp = new StringBuilder())) < 2) {
            temp.insert(0, '(');
            temp.append(')');
        }
        buffer.append(temp);
        if (root != 1 || pow != 1) {
            if (root == 1 && pow > 1) {
                String powStr = Integer.toString(pow);
                int i = 0;
                while (i < powStr.length()) {
                    char c = powStr.charAt(i);
                    switch (c) {
                        case '0': {
                            buffer.append('\u2070');
                            break;
                        }
                        case '1': {
                            buffer.append('\u00b9');
                            break;
                        }
                        case '2': {
                            buffer.append('\u00b2');
                            break;
                        }
                        case '3': {
                            buffer.append('\u00b3');
                            break;
                        }
                        case '4': {
                            buffer.append('\u2074');
                            break;
                        }
                        case '5': {
                            buffer.append('\u2075');
                            break;
                        }
                        case '6': {
                            buffer.append('\u2076');
                            break;
                        }
                        case '7': {
                            buffer.append('\u2077');
                            break;
                        }
                        case '8': {
                            buffer.append('\u2078');
                            break;
                        }
                        case '9': {
                            buffer.append('\u2079');
                        }
                    }
                    ++i;
                }
            } else if (root == 1) {
                buffer.append('^');
                buffer.append(String.valueOf(pow));
            } else {
                buffer.append("^(");
                buffer.append(String.valueOf(pow));
                buffer.append('/');
                buffer.append(String.valueOf(root));
                buffer.append(')');
            }
        }
    }

    private int formatConverter(UnitConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        ParsePrefix prefix = this.symbolMap.getPrefixObject((AbstractConverter)converter);
        if (prefix != null && unitPrecedence == Integer.MAX_VALUE) {
            buffer.insert(0, this.symbolMap.getSymbol(prefix));
            return Integer.MAX_VALUE;
        }
        if (converter instanceof AddConverter) {
            double offset;
            if (unitPrecedence < 0) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if ((offset = ((AddConverter)converter).getOffset()) < 0.0) {
                buffer.append("-");
                offset = -offset;
            } else if (continued) {
                buffer.append("+");
            }
            long lOffset = (long)offset;
            if ((double)lOffset == offset) {
                buffer.append(lOffset);
            } else {
                buffer.append(offset);
            }
            return 0;
        }
        if (converter instanceof LogConverter) {
            double base = ((LogConverter)converter).getBase();
            StringBuffer expr = new StringBuffer();
            if (base == Math.E) {
                expr.append("ln");
            } else {
                expr.append("log");
                if (base != 10.0) {
                    expr.append((int)base);
                }
            }
            expr.append("(");
            buffer.insert(0, expr);
            buffer.append(")");
            return 4;
        }
        if (converter instanceof ExpConverter) {
            if (unitPrecedence < 4) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            StringBuffer expr = new StringBuffer();
            double base = ((ExpConverter)converter).getBase();
            if (base == Math.E) {
                expr.append('e');
            } else {
                expr.append((int)base);
            }
            expr.append('^');
            buffer.insert(0, expr);
            return 4;
        }
        if (converter instanceof MultiplyConverter) {
            double factor;
            long lFactor;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if (continued) {
                buffer.append('\u00b7');
            }
            if ((double)(lFactor = (long)(factor = ((MultiplyConverter)converter).getFactor())) == factor) {
                buffer.append(lFactor);
            } else {
                buffer.append(factor);
            }
            return 2;
        }
        if (converter instanceof RationalConverter) {
            RationalConverter rationalConverter;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if (!(rationalConverter = (RationalConverter)converter).getDividend().equals(BigInteger.ONE)) {
                if (continued) {
                    buffer.append('\u00b7');
                }
                buffer.append(rationalConverter.getDividend());
            }
            if (!rationalConverter.getDivisor().equals(BigInteger.ONE)) {
                buffer.append('/');
                buffer.append(rationalConverter.getDivisor());
            }
            return 2;
        }
        if (converter instanceof AbstractConverter.Compound) {
            AbstractConverter.Compound compound = (AbstractConverter.Compound)converter;
            if (compound.getLeft() == AbstractConverter.IDENTITY) {
                return this.formatConverter(compound.getRight(), true, unitPrecedence, buffer);
            }
            if (compound.getLeft() instanceof Formattable) {
                return this.formatFormattable((Formattable)((Object)compound.getLeft()), unitPrecedence, buffer);
            }
            if (compound.getRight() instanceof Formattable) {
                return this.formatFormattable((Formattable)((Object)compound.getRight()), unitPrecedence, buffer);
            }
            return this.formatConverter(compound.getLeft(), true, unitPrecedence, buffer);
        }
        if (converter != null) {
            buffer.replace(0, 1, converter.toString());
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Unable to format, no UnitConverter given");
    }

    private int formatFormattable(Formattable f, int unitPrecedence, StringBuilder buffer) {
        Formatter fmt = new Formatter();
        fmt.format(Messages.LocalFormat_Pattern, f);
        buffer.replace(0, 1, fmt.toString());
        fmt.close();
        return unitPrecedence;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        try {
            Unit unit = (Unit)obj;
            return (StringBuffer)this.format(unit, toAppendTo);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException("Invalid type: " + obj.getClass().getName());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid type: " + obj.getClass().getName());
        }
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public Locale getLocale() {
        return this.uLocale;
    }

    public boolean isLocaleSensitive() {
        return true;
    }

    public void label(Unit<?> arg0, String arg1) {
    }
}

