/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import javax.measure.UnitConverter;
import org.eclipse.uomo.core.UOMoRuntimeException;
import org.eclipse.uomo.core.impl.OutputHelper;
import org.eclipse.uomo.ucum.expression.Component;
import org.eclipse.uomo.ucum.expression.Factor;
import org.eclipse.uomo.ucum.expression.Operator;
import org.eclipse.uomo.ucum.expression.Symbol;
import org.eclipse.uomo.ucum.expression.Term;
import org.eclipse.uomo.ucum.impl.Canonical;
import org.eclipse.uomo.ucum.model.ConceptKind;
import org.eclipse.uomo.ucum.model.DefinedUnit;
import org.eclipse.uomo.ucum.model.UcumModel;
import org.eclipse.uomo.ucum.parsers.ExpressionComposer;
import org.eclipse.uomo.ucum.parsers.ExpressionParser;
import org.eclipse.uomo.ucum.special.SpecialUnitHandler;
import org.eclipse.uomo.util.Registry;
import tech.units.indriya.AbstractConverter;

class UcumConverter
implements UnitConverter,
Serializable,
Comparable<UnitConverter> {
    private static final long serialVersionUID = -895607408258138526L;
    private final UcumModel model;
    private final Registry<SpecialUnitHandler> handlers;
    private final UnitConverter compound;
    private Factor one = new Factor(1);

    public UcumConverter(UcumModel model, Registry handlers) {
        this.model = model;
        this.handlers = handlers;
        List<UnitConverter> compounds = this.getCompoundConverters();
        this.compound = compounds.get(0);
    }

    public Canonical convert(Term term) throws UOMoRuntimeException {
        return this.convertTerm(term);
    }

    private Canonical convertTerm(Term term) throws UOMoRuntimeException {
        Canonical res = new Canonical(BigDecimal.ONE, new Term());
        if (term.hasComp()) {
            res.getUnit().setComp(this.convertComp(res, term.getComp()));
        }
        if (term.hasOp()) {
            res.getUnit().setOp(term.getOp());
        }
        if (term.hasTerm()) {
            Canonical t = this.convertTerm(term.getTerm());
            res.setValue(res.getValue().multiply(t.getValue()));
            if (t.hasUnit()) {
                res.getUnit().setTermCheckOp(t.getUnit());
            } else {
                res.getUnit().setOp(null);
            }
        }
        this.debug("normalise", res.getUnit());
        if (res.getUnit().hasOp() && res.getUnit().getOp() == Operator.DIVISION) {
            res.getUnit().setOp(Operator.MULTIPLICATION);
            this.flipExponents(res.getUnit().getTerm());
            this.debug("flipped", res.getUnit());
        }
        if (!res.getUnit().hasComp() || res.getUnit().getComp() == this.one) {
            res.setUnit(res.getUnit().getTerm());
            this.debug("trimmed", res.getUnit());
        }
        if (res.hasUnit() && res.getUnit().hasComp() && res.getUnit().getComp() instanceof Term) {
            Term end = this.getEndTerm((Term)res.getUnit().getComp());
            assert (end.getOp() == null);
            end.setOp(Operator.MULTIPLICATION);
            end.setTermCheckOp(res.getUnit().getTerm());
            res.setUnit((Term)res.getUnit().getComp());
            this.debug("reorged", res.getUnit());
        }
        if (res.hasUnit() && (!res.getUnit().hasComp() || res.getUnit().getComp() == this.one)) {
            res.setUnit(res.getUnit().getTerm());
            this.debug("trimmed", res.getUnit());
        }
        if (res.hasUnit()) {
            res.setUnit(this.removeDuplicateComponents(res.getUnit()));
        }
        if (res.hasUnit() && !res.getUnit().hasTerm()) {
            res.getUnit().setOp(null);
        }
        this.debug("norm finished", res.getUnit());
        return res;
    }

    private void debug(String state, Term unit) {
        if (OutputHelper.isConsoleOutput()) {
            OutputHelper.println((String)(String.valueOf(state) + ": " + new ExpressionComposer().compose(unit)));
        }
    }

    private Term getEndTerm(Term term) {
        if (term.hasTerm()) {
            return this.getEndTerm(term.getTerm());
        }
        return term;
    }

    private Term removeDuplicateComponents(Term unit) {
        if (unit == null) {
            return null;
        }
        assert (unit.getComp() instanceof Symbol);
        Symbol symO = (Symbol)unit.getComp();
        Term inner = this.findDuplicateCompOwner(unit.getTerm(), symO);
        if (inner != null) {
            Symbol symI = (Symbol)inner.getComp();
            symI.setExponent(symI.getExponent() + symO.getExponent());
            return this.removeDuplicateComponents(unit.getTerm());
        }
        if (symO.getExponent() == 0) {
            return this.removeDuplicateComponents(unit.getTerm());
        }
        unit.setTermCheckOp(this.removeDuplicateComponents(unit.getTerm()));
        return unit;
    }

    private Term findDuplicateCompOwner(Term term, Symbol comp) {
        Symbol sym;
        if (term == null) {
            return null;
        }
        if (term.getComp() instanceof Symbol && (sym = (Symbol)term.getComp()).getPrefix() == comp.getPrefix() && sym.getUnit() == comp.getUnit()) {
            return term;
        }
        return this.findDuplicateCompOwner(term.getTerm(), comp);
    }

    private void flipExponents(Term term) {
        if (term.getComp() instanceof Symbol) {
            ((Symbol)term.getComp()).invertExponent();
        }
        if (term.hasTerm()) {
            this.flipExponents(term.getTerm());
        }
    }

    private Component convertComp(Canonical ctxt, Component comp) throws UOMoRuntimeException {
        if (comp instanceof Term) {
            Canonical t = this.convertTerm((Term)comp);
            ctxt.multiplyValue(t.getValue());
            return t.getUnit();
        }
        if (comp instanceof Factor) {
            ctxt.multiplyValue(((Factor)comp).getValue());
            return this.one;
        }
        if (comp instanceof Symbol) {
            return this.convertSymbol(ctxt, (Symbol)comp);
        }
        throw new UOMoRuntimeException("unknown component type " + comp.getClass().toString());
    }

    private Component convertSymbol(Canonical ctxt, Symbol comp) throws UOMoRuntimeException {
        if (comp.hasPrefix()) {
            ctxt.multiplyValue(((BigDecimal)comp.getPrefix().getValue()).pow(comp.getExponent(), MathContext.DECIMAL128));
        }
        if (comp.getUnit().getKind() == ConceptKind.BASEUNIT) {
            Symbol res = new Symbol();
            res.setUnit(comp.getUnit());
            res.setExponent(comp.getExponent());
            return res;
        }
        DefinedUnit unit = (DefinedUnit)comp.getUnit();
        String u = unit.getValue().getCode();
        if (unit.isSpecial()) {
            if (!this.handlers.exists(unit.getCode())) {
                throw new UOMoRuntimeException("Not handled yet (special unit)");
            }
            u = ((SpecialUnitHandler)this.handlers.get(unit.getCode())).getUnits();
            ctxt.multiplyValue(((SpecialUnitHandler)this.handlers.get(unit.getCode())).getValue());
        } else {
            ctxt.multiplyValue(unit.getValue().value());
        }
        Term canonical = new ExpressionParser(this.model).parse(u);
        if (canonical.hasComp() && !canonical.hasOp() && !canonical.hasTerm()) {
            Component ret = this.convertComp(ctxt, canonical.getComp());
            if (comp.getExponent() == 1) {
                return ret;
            }
            if (ret instanceof Factor) {
                ((Factor)ret).setValue(comp.getExponent() + ((Factor)ret).getValue());
                return ret;
            }
            if (ret instanceof Symbol) {
                ((Symbol)ret).setExponent(comp.getExponent() * ((Symbol)ret).getExponent());
                return ret;
            }
            if (ret instanceof Term) {
                this.applyExponent((Term)ret, comp.getExponent());
                return ret;
            }
            throw new UOMoRuntimeException("unknown component type " + comp.getClass().toString());
        }
        Canonical t1 = this.convertTerm(canonical);
        Term ret = t1.getUnit();
        if (comp.getExponent() == -1 && ret.hasComp() && ret.hasOp() && ret.hasTerm() && ret.getTerm().hasComp() && !ret.getTerm().hasOp() && !ret.getTerm().hasTerm()) {
            Component t = ret.getTerm().getComp();
            ret.getTerm().setComp(ret.getComp());
            ret.setComp(t);
            ctxt.divideValue(t1.getValue());
            return ret;
        }
        if (comp.getExponent() != 1) {
            ctxt.multiplyValue(t1.getValue());
            this.applyExponent(ret, comp.getExponent());
            return ret;
        }
        ctxt.multiplyValue(t1.getValue());
        return ret;
    }

    private void applyExponent(Term term, int exponent) {
        if (term == null) {
            return;
        }
        if (term.hasComp()) {
            if (term.getComp() instanceof Term) {
                this.applyExponent((Term)term.getComp(), exponent);
            } else if (term.getComp() instanceof Symbol) {
                Symbol sym = (Symbol)term.getComp();
                sym.setExponent(sym.getExponent() * exponent);
            }
        }
        this.applyExponent(term.getTerm(), exponent);
    }

    public UnitConverter concatenate(UnitConverter converter) {
        return this.compound.concatenate(converter);
    }

    public double convert(double value) {
        return this.compound.convert(value);
    }

    public List<UnitConverter> getCompoundConverters() {
        ArrayList<UnitConverter> compound = new ArrayList<UnitConverter>();
        compound.add(this);
        return compound;
    }

    public AbstractConverter inverse() {
        return (AbstractConverter)this.compound.inverse();
    }

    public boolean isIdentity() {
        return false;
    }

    public boolean isLinear() {
        return false;
    }

    public Number convert(Number value) {
        return this.compound.convert(value);
    }

    public boolean equals(Object arg0) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(UnitConverter o) {
        return 0;
    }

    public List<? extends UnitConverter> getConversionSteps() {
        return null;
    }
}

