/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.eventlog.impl;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.virgo.medic.eventlog.impl.LocaleResolver;
import org.eclipse.virgo.medic.eventlog.impl.MessageResolver;
import org.eclipse.virgo.medic.eventlog.impl.PropertyResourceBundleResolver;
import org.eclipse.virgo.medic.eventlog.impl.ResourceBundleUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardMessageResolver
implements MessageResolver {
    private static final String RESOURCE_BUNDLE_NAME = "EventLogMessages";
    private final LocaleResolver localeResolver;
    private final PropertyResourceBundleResolver resourceBundleLocator;
    private final Bundle primaryBundle;
    private final Bundle secondaryBundle;

    public StandardMessageResolver(LocaleResolver localeResolver, PropertyResourceBundleResolver resourceBundleLocator, Bundle primaryBundle, Bundle secondaryBundle) {
        this.localeResolver = localeResolver;
        this.resourceBundleLocator = resourceBundleLocator;
        this.primaryBundle = primaryBundle;
        this.secondaryBundle = secondaryBundle;
    }

    @Override
    public String resolveLogEventMessage(String eventCode) {
        return this.resolveLogEventMessage(eventCode, this.localeResolver.getLocale());
    }

    @Override
    public String resolveLogEventMessage(String eventCode, Locale locale) {
        List<String> candidatePropertiesFileNames = ResourceBundleUtils.generateCandidatePropertiesFileNames(RESOURCE_BUNDLE_NAME, locale);
        String message = this.resolveMessageInBundle(this.primaryBundle, eventCode, candidatePropertiesFileNames);
        if (message == null) {
            message = this.resolveMessageInBundle(this.secondaryBundle, eventCode, candidatePropertiesFileNames);
        }
        return message;
    }

    private String resolveMessageInBundle(Bundle bundle, String key, List<String> candidatePropertiesFileNames) {
        for (String candidatePropertiesFileName : candidatePropertiesFileNames) {
            List<PropertyResourceBundle> resourceBundles = this.resourceBundleLocator.getResourceBundles(bundle, candidatePropertiesFileName);
            for (PropertyResourceBundle resourceBundle : resourceBundles) {
                try {
                    String string = resourceBundle.getString(key);
                    if (string == null) continue;
                    return string;
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        return null;
    }
}

