/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.shell.Command;
import org.eclipse.virgo.kernel.shell.internal.formatting.InstallArtifactCommandFormatter;
import org.eclipse.virgo.kernel.shell.internal.util.ArtifactRetriever;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;

abstract class AbstractInstallArtifactBasedCommands<T extends ManageableArtifact> {
    private static final String NO_ARTIFACT_FOR_NAME_AND_VERSION = "No %s with name '%s' and version '%s' was found";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final String type;
    private final RuntimeArtifactModelObjectNameCreator objectNameCreator;
    private final InstallArtifactCommandFormatter<T> formatter;
    private final ArtifactRetriever<T> artifactRetriever;
    private final Region kernelRegion;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public AbstractInstallArtifactBasedCommands(String type, RuntimeArtifactModelObjectNameCreator objectNameCreator, InstallArtifactCommandFormatter<T> formatter, Class<T> artifactType, RegionDigraph regionDigraph) {
        this.type = type;
        this.objectNameCreator = objectNameCreator;
        this.formatter = formatter;
        this.artifactRetriever = new ArtifactRetriever<T>(type, objectNameCreator, artifactType);
        this.kernelRegion = regionDigraph == null ? null : regionDigraph.getRegion(0L);
    }

    @Command(value="list")
    public List<String> list() {
        try {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Set<ObjectName> objectNames = this.server.queryNames(this.objectNameCreator.createArtifactsOfTypeQuery(this.type), null);
            ArrayList<T> artifacts = new ArrayList<T>(objectNames.size());
            for (ObjectName objectName : objectNames) {
                try {
                    artifacts.add(this.artifactRetriever.getArtifact(objectName));
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
            List<String> list = this.formatter.formatList(artifacts);
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return list;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Command(value="examine")
    public List<String> examine(String name, String versionString) {
        try {
            List<String> list;
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            Version version = AbstractInstallArtifactBasedCommands.convertToVersion(versionString);
            try {
                list = this.formatter.formatExamine(this.artifactRetriever.getArtifact(name, version));
            }
            catch (IllegalArgumentException iae) {
                list = Arrays.asList(iae.getMessage());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.kernelRegion != null) {
                    try {
                        list = this.formatter.formatExamine(this.artifactRetriever.getArtifact(name, version, this.kernelRegion));
                    }
                    catch (InstanceNotFoundException instanceNotFoundException2) {
                        list = this.getDoesNotExistMessage(this.type, name, versionString);
                    }
                }
                list = this.getDoesNotExistMessage(this.type, name, versionString);
            }
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return list;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    protected List<String> getDoesNotExistMessage(String type, String name, String version) {
        return Arrays.asList(String.format(NO_ARTIFACT_FOR_NAME_AND_VERSION, type, name, version));
    }

    @Command(value="start")
    public List<String> start(String name, String version) {
        try {
            List<String> list;
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            try {
                this.artifactRetriever.getArtifact(name, AbstractInstallArtifactBasedCommands.convertToVersion(version)).start();
                list = Arrays.asList(String.format("%s %s:%s started successfully", this.type, name, version));
            }
            catch (IllegalArgumentException iae) {
                list = Arrays.asList(iae.getMessage());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                list = this.getDoesNotExistMessage(this.type, name, version);
            }
            catch (Exception e) {
                list = Arrays.asList(String.format("%s %s:%s start failed", this.type, name, version), "", "", this.formatException(e));
            }
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return list;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    @Command(value="stop")
    public List<String> stop(String name, String version) {
        try {
            List<String> list;
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            try {
                this.artifactRetriever.getArtifact(name, AbstractInstallArtifactBasedCommands.convertToVersion(version)).stop();
                list = Arrays.asList(String.format("%s %s:%s stopped successfully", this.type, name, version));
            }
            catch (IllegalArgumentException iae) {
                list = Arrays.asList(iae.getMessage());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                list = this.getDoesNotExistMessage(this.type, name, version);
            }
            catch (Exception e) {
                list = Arrays.asList(String.format("%s %s:%s stop failed", this.type, name, version), "", "", this.formatException(e));
            }
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return list;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    @Command(value="refresh")
    public List<String> refresh(String name, String version) {
        try {
            List<String> list;
            block7: {
                AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
                if (!this.artifactRetriever.getArtifact(name, AbstractInstallArtifactBasedCommands.convertToVersion(version)).refresh()) break block7;
                list = Arrays.asList(String.format("%s %s:%s refreshed successfully", this.type, name, version));
            }
            try {
                list = Arrays.asList(String.format("%s %s:%s not refreshed, no changes made", this.type, name, version));
            }
            catch (IllegalArgumentException iae) {
                list = Arrays.asList(iae.getMessage());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                list = this.getDoesNotExistMessage(this.type, name, version);
            }
            catch (Exception e) {
                list = Arrays.asList(String.format("%s %s:%s refresh failed", this.type, name, version), "", "", this.formatException(e));
            }
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return list;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    @Command(value="uninstall")
    public List<String> uninstall(String name, String version) {
        try {
            List<String> list;
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            try {
                this.artifactRetriever.getArtifact(name, AbstractInstallArtifactBasedCommands.convertToVersion(version)).uninstall();
                list = Arrays.asList(String.format("%s %s%s uninstalled successfully", this.type, name, version));
            }
            catch (IllegalArgumentException iae) {
                list = Arrays.asList(iae.getMessage());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                list = this.getDoesNotExistMessage(this.type, name, version);
            }
            catch (Exception e) {
                list = Arrays.asList(String.format("%s %s:%s uninstall failed", this.type, name, version), "", "", this.formatException(e));
            }
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return list;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    protected final ArtifactRetriever<T> getArtifactRetriever() {
        return this.artifactRetriever;
    }

    private String formatException(Exception e) {
        try {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            StringWriter formattedException = new StringWriter();
            PrintWriter writer = new PrintWriter(formattedException);
            e.printStackTrace(writer);
            String string = formattedException.toString();
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return string;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    static Version convertToVersion(String versionString) {
        try {
            Version version;
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            try {
                version = new Version(versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid version", versionString));
            }
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return version;
        }
        catch (Throwable throwable) {
            AbstractInstallArtifactBasedCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("AbstractInstallArtifactBasedCommands.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "", "", "", "java.util.List"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "examine", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "java.lang.String:java.lang.String:", "name:versionString:", "", "java.util.List"), 86);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "java.lang.String:java.lang.String:", "name:version:", "", "java.util.List"), 111);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "java.lang.String:java.lang.String:", "name:version:", "", "java.util.List"), 125);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "java.lang.String:java.lang.String:", "name:version:", "", "java.util.List"), 139);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uninstall", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "java.lang.String:java.lang.String:", "name:version:", "", "java.util.List"), 156);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatException", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "java.lang.Exception:", "e:", "", "java.lang.String"), 172);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "convertToVersion", "org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands", "java.lang.String:", "versionString:", "", "org.osgi.framework.Version"), 181);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands");
    }
}

