/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.pop3;

import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.geronimo.javamail.store.pop3.POP3CommandFactory;
import org.apache.geronimo.javamail.store.pop3.POP3Connection;
import org.apache.geronimo.javamail.store.pop3.POP3Folder;
import org.apache.geronimo.javamail.store.pop3.POP3Response;

public class POP3Store
extends Store {
    private POP3Connection pop3Con;
    protected static final int DEFAULT_MAIL_POP3_PORT = 110;
    private boolean sslConnection;
    private int defaultPort;
    private String protocol;

    public POP3Store(Session session, URLName name) {
        this(session, name, "pop3", 110, false);
    }

    protected POP3Store(Session session, URLName name, String protocol, int defaultPort, boolean sslConnection) {
        super(session, name);
        this.protocol = protocol;
        this.sslConnection = sslConnection;
        this.defaultPort = defaultPort;
    }

    public Folder getDefaultFolder() throws MessagingException {
        return this.getFolder("INBOX");
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnectionStatus();
        if (!"INBOX".equalsIgnoreCase(name)) {
            throw new MessagingException("Only INBOX is supported in POP3");
        }
        return new POP3Folder(this, this.session, this.pop3Con);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        return this.getFolder(url.getFile());
    }

    protected synchronized boolean protocolConnect(String host, int portNum, String user, String passwd) throws MessagingException {
        String portstring;
        if (host == null || passwd == null || user == null) {
            return false;
        }
        if (portNum < 1 && (portstring = this.session.getProperty("mail.pop3.port")) != null) {
            try {
                portNum = Integer.parseInt(portstring);
            }
            catch (NumberFormatException e) {
                portNum = this.defaultPort;
            }
        }
        this.pop3Con = new POP3Connection(this.session, host, portNum, this.sslConnection, this.protocol);
        try {
            this.pop3Con.open();
        }
        catch (Exception e) {
            throw new MessagingException("Connection failed", e);
        }
        POP3Response resUser = null;
        try {
            resUser = this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_USER(user));
        }
        catch (Exception e) {
            throw new MessagingException("Connection failed", e);
        }
        if (1 == resUser.getStatus()) {
            try {
                this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_QUIT());
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new AuthenticationFailedException(resUser.getFirstLine());
        }
        POP3Response resPwd = null;
        try {
            resPwd = this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_PASS(passwd));
        }
        catch (Exception e) {
            throw new MessagingException("Connection failed", e);
        }
        if (1 == resPwd.getStatus()) {
            try {
                this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_QUIT());
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new AuthenticationFailedException(resPwd.getFirstLine());
        }
        return true;
    }

    public boolean isConnected() {
        POP3Response res = null;
        try {
            res = this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_NOOP());
        }
        catch (Exception e) {
            return false;
        }
        return 0 == res.getStatus();
    }

    public void close() throws MessagingException {
        super.close();
        try {
            this.pop3Con.close();
        }
        catch (Exception e) {
            new MessagingException("", e);
        }
    }

    private void checkConnectionStatus() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected ");
        }
    }
}

