/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.ResAuth;
import org.apache.openejb.jee.ResSharingScope;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="resource-refType", propOrder={"descriptions", "resRefName", "resType", "resAuth", "resSharingScope", "mappedName", "injectionTarget", "lookupName"})
public class ResourceRef
implements JndiReference {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="res-ref-name", required=true)
    protected String resRefName;
    @XmlElement(name="res-type")
    protected String resType;
    @XmlElement(name="res-auth")
    protected ResAuth resAuth;
    @XmlElement(name="res-sharing-scope")
    protected ResSharingScope resSharingScope = ResSharingScope.SHAREABLE;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public ResourceRef() {
    }

    public ResourceRef(String resRefName, String resType) {
        this.resRefName = resRefName;
        this.resType = resType;
    }

    public ResourceRef(String resRefName, String resType, ResAuth resAuth, ResSharingScope resSharingScope) {
        this.resRefName = resRefName;
        this.resType = resType;
        this.resAuth = resAuth;
        this.resSharingScope = resSharingScope;
    }

    public ResourceRef name(String resRefName) {
        this.resRefName = resRefName;
        return this;
    }

    public ResourceRef type(String resType) {
        this.resType = resType;
        return this;
    }

    public ResourceRef auth(ResAuth resAuth) {
        this.resAuth = resAuth;
        return this;
    }

    public ResourceRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public ResourceRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public ResourceRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.resRefName == null) {
            this.resRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public ResourceRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.getResRefName();
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    @XmlTransient
    public String getType() {
        return this.getResType();
    }

    @Override
    public void setName(String name) {
        this.setResRefName(name);
    }

    @Override
    public void setType(String type) {
        this.setResType(type);
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getResRefName() {
        return this.resRefName;
    }

    public void setResRefName(String value) {
        this.resRefName = value;
    }

    public String getResType() {
        return this.resType;
    }

    public void setResType(String value) {
        this.resType = value;
    }

    public ResAuth getResAuth() {
        return this.resAuth;
    }

    public void setResAuth(ResAuth value) {
        this.resAuth = value;
    }

    public ResSharingScope getResSharingScope() {
        return this.resSharingScope;
    }

    public void setResSharingScope(ResSharingScope value) {
        this.resSharingScope = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "ResourceRef{name='" + this.resRefName + '\'' + ", type='" + this.resType + '\'' + ", mappedName='" + this.mappedName + '\'' + ", lookupName='" + this.lookupName + '\'' + '}';
    }
}

