/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;

public class PointbaseDelegate
extends StdJDBCDelegate {
    static /* synthetic */ Class class$org$quartz$SimpleTrigger;
    static /* synthetic */ Class class$org$quartz$CronTrigger;

    public PointbaseDelegate(Log logger, String tablePrefix, String instanceId) {
        super(logger, tablePrefix, instanceId);
    }

    public PointbaseDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties) {
        super(logger, tablePrefix, instanceId, useProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        int len = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.setString(3, job.getDescription());
            ps.setString(4, job.getJobClass().getName());
            this.setBoolean(ps, 5, job.isDurable());
            this.setBoolean(ps, 6, job.isVolatile());
            this.setBoolean(ps, 7, job.isStateful());
            this.setBoolean(ps, 8, job.requestsRecovery());
            ps.setBinaryStream(9, (InputStream)bais, len);
            insertResult = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        if (insertResult > 0) {
            String[] jobListeners = job.getJobListenerNames();
            for (int i = 0; jobListeners != null && i < jobListeners.length; ++i) {
                this.insertJobListener(conn, job, jobListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        int len = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, job.getDescription());
            ps.setString(2, job.getJobClass().getName());
            this.setBoolean(ps, 3, job.isDurable());
            this.setBoolean(ps, 4, job.isVolatile());
            this.setBoolean(ps, 5, job.isStateful());
            this.setBoolean(ps, 6, job.requestsRecovery());
            ps.setBinaryStream(7, (InputStream)bais, len);
            ps.setString(8, job.getName());
            ps.setString(9, job.getGroup());
            insertResult = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        if (insertResult > 0) {
            this.deleteJobListeners(conn, job.getName(), job.getGroup());
            String[] jobListeners = job.getJobListenerNames();
            for (int i = 0; jobListeners != null && i < jobListeners.length; ++i) {
                this.insertJobListener(conn, job, jobListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
        int len = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA, PRIORITY)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setString(3, trigger.getJobName());
            ps.setString(4, trigger.getJobGroup());
            this.setBoolean(ps, 5, trigger.isVolatile());
            ps.setString(6, trigger.getDescription());
            ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
            long prevFireTime = -1L;
            if (trigger.getPreviousFireTime() != null) {
                prevFireTime = trigger.getPreviousFireTime().getTime();
            }
            ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
            ps.setString(9, state);
            if (trigger.getClass() == (class$org$quartz$SimpleTrigger == null ? (class$org$quartz$SimpleTrigger = PointbaseDelegate.class$("org.quartz.SimpleTrigger")) : class$org$quartz$SimpleTrigger)) {
                ps.setString(10, "SIMPLE");
            } else if (trigger.getClass() == (class$org$quartz$CronTrigger == null ? (class$org$quartz$CronTrigger = PointbaseDelegate.class$("org.quartz.CronTrigger")) : class$org$quartz$CronTrigger)) {
                ps.setString(10, "CRON");
            } else {
                ps.setString(10, "BLOB");
            }
            ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
            long endTime = 0L;
            if (trigger.getEndTime() != null) {
                endTime = trigger.getEndTime().getTime();
            }
            ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
            ps.setString(13, trigger.getCalendarName());
            ps.setInt(14, trigger.getMisfireInstruction());
            ps.setBinaryStream(15, (InputStream)bais, len);
            ps.setInt(16, trigger.getPriority());
            insertResult = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        if (insertResult > 0) {
            String[] trigListeners = trigger.getTriggerListenerNames();
            for (int i = 0; trigListeners != null && i < trigListeners.length; ++i) {
                this.insertTriggerListener(conn, trigger, trigListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        ByteArrayOutputStream baos = this.serializeJobData(trigger.getJobDataMap());
        int len = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        int insertResult = 0;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, PRIORITY = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, trigger.getJobName());
            ps.setString(2, trigger.getJobGroup());
            this.setBoolean(ps, 3, trigger.isVolatile());
            ps.setString(4, trigger.getDescription());
            long nextFireTime = -1L;
            if (trigger.getNextFireTime() != null) {
                nextFireTime = trigger.getNextFireTime().getTime();
            }
            ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
            long prevFireTime = -1L;
            if (trigger.getPreviousFireTime() != null) {
                prevFireTime = trigger.getPreviousFireTime().getTime();
            }
            ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
            ps.setString(7, state);
            if (trigger.getClass() == (class$org$quartz$SimpleTrigger == null ? (class$org$quartz$SimpleTrigger = PointbaseDelegate.class$("org.quartz.SimpleTrigger")) : class$org$quartz$SimpleTrigger)) {
                ps.setString(8, "SIMPLE");
            } else if (trigger.getClass() == (class$org$quartz$CronTrigger == null ? (class$org$quartz$CronTrigger = PointbaseDelegate.class$("org.quartz.CronTrigger")) : class$org$quartz$CronTrigger)) {
                ps.setString(8, "CRON");
            } else {
                ps.setString(8, "BLOB");
            }
            ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
            long endTime = 0L;
            if (trigger.getEndTime() != null) {
                endTime = trigger.getEndTime().getTime();
            }
            ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
            ps.setString(11, trigger.getCalendarName());
            ps.setInt(12, trigger.getMisfireInstruction());
            ps.setInt(13, trigger.getPriority());
            ps.setBinaryStream(14, (InputStream)bais, len);
            ps.setString(15, trigger.getName());
            ps.setString(16, trigger.getGroup());
            insertResult = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        if (insertResult > 0) {
            this.deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
            String[] trigListeners = trigger.getTriggerListenerNames();
            for (int i = 0; trigListeners != null && i < trigListeners.length; ++i) {
                this.insertTriggerListener(conn, trigger, trigListeners[i]);
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        int len = baos.toByteArray().length;
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setBinaryStream(1, (InputStream)bais, len);
            ps.setString(2, job.getName());
            ps.setString(3, job.getGroup());
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
            ps.setString(1, calendarName);
            ps.setBinaryStream(2, (InputStream)bais, buf.length);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        byte[] buf = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
            ps.setBinaryStream(1, (InputStream)bais, buf.length);
            ps.setString(2, calendarName);
            n = ps.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeStatement(ps);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        Object obj = null;
        byte[] binaryData = rs.getBytes(colName);
        ByteArrayInputStream binaryInput = new ByteArrayInputStream(binaryData);
        if (null != binaryInput) {
            ObjectInputStream in = new ObjectInputStream(binaryInput);
            try {
                obj = in.readObject();
            }
            finally {
                in.close();
            }
        }
        return obj;
    }

    protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            byte[] data = rs.getBytes(colName);
            if (data == null) {
                return null;
            }
            ByteArrayInputStream binaryInput = new ByteArrayInputStream(data);
            return binaryInput;
        }
        return this.getObjectFromBlob(rs, colName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

