/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal.uri;

import java.net.URI;
import org.eclipse.virgo.nano.deployer.api.core.DeployUriNormaliser;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;

class CompoundDeployUriNormaliser
implements DeployUriNormaliser {
    private final DeployUriNormaliser[] normalisers;

    public CompoundDeployUriNormaliser(@NonNull DeployUriNormaliser[] normalisers) {
        this.normalisers = (DeployUriNormaliser[])normalisers.clone();
    }

    public URI normalise(URI uri) throws DeploymentException {
        DeployUriNormaliser[] deployUriNormaliserArray = this.normalisers;
        int n = this.normalisers.length;
        int n2 = 0;
        while (n2 < n) {
            DeployUriNormaliser normaliser = deployUriNormaliserArray[n2];
            URI normalised = normaliser.normalise(uri);
            if (normalised != null) {
                return normalised;
            }
            ++n2;
        }
        return null;
    }
}

