/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.tomcat.support;

import java.lang.instrument.ClassFileTransformer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.eclipse.virgo.kernel.osgi.framework.InstrumentableClassLoader;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFramework;
import org.eclipse.virgo.web.tomcat.support.FindResourceDelegatingClassLoader;
import org.osgi.framework.Bundle;

final class ServerClassLoaderCustomizer
implements ClassLoaderCustomizer {
    private final OsgiFramework framework;

    public ServerClassLoaderCustomizer(OsgiFramework framework) {
        this.framework = framework;
    }

    public ClassLoader[] extendClassLoaderChain(Bundle bundle) {
        final Bundle[] dependencies = this.framework.getDirectDependencies(bundle);
        if (dependencies.length > 0) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader[]>(){

                @Override
                public ClassLoader[] run() {
                    return new ClassLoader[]{new FindResourceDelegatingClassLoader(dependencies)};
                }
            });
        }
        return new ClassLoader[0];
    }

    public void addClassFileTransformer(ClassFileTransformer transformer, Bundle bundle) {
        ClassLoader bundleClassLoader = this.framework.getBundleClassLoader(bundle);
        if (bundleClassLoader instanceof InstrumentableClassLoader) {
            ((InstrumentableClassLoader)bundleClassLoader).addClassFileTransformer(transformer);
        }
    }

    public ClassLoader createThrowawayClassLoader(Bundle bundle) {
        ClassLoader bundleClassLoader = this.framework.getBundleClassLoader(bundle);
        if (bundleClassLoader instanceof InstrumentableClassLoader) {
            return ((InstrumentableClassLoader)bundleClassLoader).createThrowAway();
        }
        return null;
    }
}

