/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceDelegate;
import org.eclipse.virgo.kernel.services.concurrent.KernelExecutorService;
import org.eclipse.virgo.kernel.services.concurrent.ThreadPoolUtils;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;

public final class KernelThreadPoolExecutor
extends ThreadPoolExecutor
implements KernelExecutorService {
    private final ExecutorServiceDelegate delegate;
    private final String poolName;

    public KernelThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String poolName, TracingService tracingService) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, poolName, tracingService, null);
    }

    public KernelThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String poolName, TracingService tracingService, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ThreadPoolUtils.createThreadFactory(poolName), ThreadPoolUtils.determineHandler(handler));
        this.poolName = poolName;
        this.delegate = new ExecutorServiceDelegate(tracingService);
    }

    @Override
    public void execute(Runnable command) {
        Runnable decorated = this.delegate.decorate(command);
        super.execute(decorated);
    }

    @Override
    public long getAverageExecutionTime() {
        return this.delegate.getAverageExecutionTime(this.getCompletedTaskCount());
    }

    @Override
    public long getExecutionTime() {
        return this.delegate.getExecutionTime();
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }
}

