/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;

public class WebSocketMessageBrokerStats {
    private static final Log logger = LogFactory.getLog(WebSocketMessageBrokerStats.class);
    private SubProtocolWebSocketHandler webSocketHandler;
    private StompSubProtocolHandler stompSubProtocolHandler;
    private StompBrokerRelayMessageHandler stompBrokerRelay;
    private ThreadPoolExecutor inboundChannelExecutor;
    private ThreadPoolExecutor outboundChannelExecutor;
    private ScheduledThreadPoolExecutor sockJsTaskScheduler;
    private ScheduledFuture<?> loggingTask;
    private long loggingPeriod = 1800000L;

    public void setSubProtocolWebSocketHandler(SubProtocolWebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
        this.stompSubProtocolHandler = this.initStompSubProtocolHandler();
    }

    private StompSubProtocolHandler initStompSubProtocolHandler() {
        for (SubProtocolHandler handler : this.webSocketHandler.getProtocolHandlers()) {
            if (!(handler instanceof StompSubProtocolHandler)) continue;
            return (StompSubProtocolHandler)handler;
        }
        SubProtocolHandler defaultHandler = this.webSocketHandler.getDefaultProtocolHandler();
        if (defaultHandler != null && defaultHandler instanceof StompSubProtocolHandler) {
            return (StompSubProtocolHandler)defaultHandler;
        }
        return null;
    }

    public void setStompBrokerRelay(StompBrokerRelayMessageHandler stompBrokerRelay) {
        this.stompBrokerRelay = stompBrokerRelay;
    }

    public void setInboundChannelExecutor(ThreadPoolTaskExecutor inboundChannelExecutor) {
        this.inboundChannelExecutor = inboundChannelExecutor.getThreadPoolExecutor();
    }

    public void setOutboundChannelExecutor(ThreadPoolTaskExecutor outboundChannelExecutor) {
        this.outboundChannelExecutor = outboundChannelExecutor.getThreadPoolExecutor();
    }

    public void setSockJsTaskScheduler(ThreadPoolTaskScheduler sockJsTaskScheduler) {
        this.sockJsTaskScheduler = sockJsTaskScheduler.getScheduledThreadPoolExecutor();
        this.loggingTask = this.initLoggingTask(60000L);
    }

    private ScheduledFuture<?> initLoggingTask(long initialDelay) {
        if (this.loggingPeriod > 0L && logger.isInfoEnabled()) {
            return this.sockJsTaskScheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)WebSocketMessageBrokerStats.this);
                }
            }, initialDelay, this.loggingPeriod, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public void setLoggingPeriod(long period) {
        if (this.loggingTask != null) {
            this.loggingTask.cancel(true);
        }
        this.loggingPeriod = period;
        this.loggingTask = this.initLoggingTask(0L);
    }

    public long getLoggingPeriod() {
        return this.loggingPeriod;
    }

    public String getWebSocketSessionStatsInfo() {
        return this.webSocketHandler != null ? this.webSocketHandler.getStatsInfo() : "null";
    }

    public String getStompSubProtocolStatsInfo() {
        return this.stompSubProtocolHandler != null ? this.stompSubProtocolHandler.getStatsInfo() : "null";
    }

    public String getStompBrokerRelayStatsInfo() {
        return this.stompBrokerRelay != null ? this.stompBrokerRelay.getStatsInfo() : "null";
    }

    public String getClientInboundExecutorStatsInfo() {
        return this.inboundChannelExecutor != null ? this.getExecutorStatsInfo(this.inboundChannelExecutor) : "null";
    }

    public String getClientOutboundExecutorStatsInfo() {
        return this.outboundChannelExecutor != null ? this.getExecutorStatsInfo(this.outboundChannelExecutor) : "null";
    }

    public String getSockJsTaskSchedulerStatsInfo() {
        return this.sockJsTaskScheduler != null ? this.getExecutorStatsInfo(this.sockJsTaskScheduler) : "null";
    }

    private String getExecutorStatsInfo(Executor executor) {
        String str = executor.toString();
        return str.substring(str.indexOf("pool"), str.length() - 1);
    }

    public String toString() {
        return "WebSocketSession[" + this.getWebSocketSessionStatsInfo() + "], stompSubProtocol[" + this.getStompSubProtocolStatsInfo() + "], stompBrokerRelay[" + this.getStompBrokerRelayStatsInfo() + "], inboundChannel[" + this.getClientInboundExecutorStatsInfo() + "], outboundChannel[" + this.getClientOutboundExecutorStatsInfo() + "], sockJsScheduler[" + this.getSockJsTaskSchedulerStatsInfo() + "]";
    }
}

