/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.config;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.virgo.snaps.core.internal.webapp.config.MutableWebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.config.StandardWebXmlValidator;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXmlParseException;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXmlParser;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleWebXmlLoader {
    private static final Logger logger = LoggerFactory.getLogger(BundleWebXmlLoader.class);
    private static final String ENTRY_WEB_XML = "WEB-INF/web.xml";
    private static final String ENTRY_DEFAULT_WEB_XML = "META-INF/snaps/default-web.xml";

    public static WebXml loadWebXml(Bundle bundle) {
        MutableWebXml webXml = new MutableWebXml();
        URL entry = bundle.getEntry(ENTRY_WEB_XML);
        BundleWebXmlLoader.doParse(entry, webXml);
        entry = FrameworkUtil.getBundle(BundleWebXmlLoader.class).getEntry(ENTRY_DEFAULT_WEB_XML);
        BundleWebXmlLoader.doParse(entry, webXml);
        BundleWebXmlLoader.validateWebXml(webXml);
        return webXml;
    }

    private static void validateWebXml(MutableWebXml webXml) {
        StandardWebXmlValidator validator = new StandardWebXmlValidator();
        validator.validate(webXml);
    }

    private static void doParse(URL webXmlUrl, MutableWebXml webXml) {
        if (webXmlUrl == null) {
            return;
        }
        InputStream stream = null;
        try {
            try {
                logger.info("Loading configuration from '{}'", (Object)webXmlUrl.toExternalForm());
                stream = webXmlUrl.openStream();
                new WebXmlParser().parse(stream, webXml);
            }
            catch (IOException e) {
                throw new WebXmlParseException("Unable to read '" + webXmlUrl + "'", e);
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                IOUtils.closeQuietly(stream);
            }
            throw throwable;
        }
        if (stream != null) {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }
}

