/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal.recovery;

import java.net.URI;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.FatalDeploymentException;
import org.eclipse.virgo.kernel.deployer.core.internal.ApplicationRecoverer;
import org.eclipse.virgo.kernel.deployer.core.internal.recovery.DeployerRecoveryLog;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

final class RecoveryAgent
implements EventHandler {
    private static final String TOPIC_SYSTEM_ARTIFACTS_DEPLOYED = "org/eclipse/virgo/kernel/userregion/systemartifacts/DEPLOYED";
    private static final String TOPIC_RECOVERY_COMPLETED = "org/eclipse/virgo/kernel/deployer/recovery/COMPLETED";
    private final ApplicationRecoverer recoverer;
    private final EventLogger eventLogger;
    private final EventAdmin eventAdmin;
    private final Map<URI, ApplicationDeployer.DeploymentOptions> recoveryState;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public RecoveryAgent(ApplicationRecoverer recoverer, DeployerRecoveryLog recoveryLog, EventLogger eventLogger, EventAdmin eventAdmin) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.recoverer = recoverer;
            this.recoveryState = recoveryLog.getRecoveryState();
            this.eventLogger = eventLogger;
            this.eventAdmin = eventAdmin;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void performRecovery() {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                if (this.isRecoveryEnabled()) {
                    Thread recoveryThread = new Thread(new Runnable(){
                        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                        {
                            try {
                                try {
                                }
                                catch (RuntimeException runtimeException) {
                                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                    throw runtimeException;
                                }
                                return;
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                        }

                        public void run() {
                            try {
                                try {
                                    1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                                    try {
                                        for (Map.Entry redeployEntry : RecoveryAgent.access$1(RecoveryAgent.this).entrySet()) {
                                            URI uri = (URI)redeployEntry.getKey();
                                            ApplicationDeployer.DeploymentOptions deploymentOptions = (ApplicationDeployer.DeploymentOptions)redeployEntry.getValue();
                                            try {
                                                RecoveryAgent.access$2(RecoveryAgent.this).recoverDeployment(uri, deploymentOptions);
                                            }
                                            catch (DeploymentException e) {
                                                RecoveryAgent.access$3(RecoveryAgent.this).log((LogEvent)DeployerLogEvents.RECOVERY_FAILED, (Throwable)e, new Object[]{uri});
                                            }
                                            catch (FatalDeploymentException e) {
                                                RecoveryAgent.access$3(RecoveryAgent.this).log((LogEvent)DeployerLogEvents.RECOVERY_FAILED, (Throwable)((Object)e), new Object[]{uri});
                                            }
                                        }
                                    }
                                    finally {
                                        RecoveryAgent.access$0(RecoveryAgent.this);
                                    }
                                    1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                                    return;
                                }
                                catch (Throwable throwable) {
                                    1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                                    throw throwable;
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                        }

                        static {
                            Factory factory = new Factory("RecoveryAgent.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent$1"));
                            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent$1", "", "", "", "void"), 67);
                            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent$1");
                        }
                    }, "deployer-recovery");
                    recoveryThread.start();
                } else {
                    this.recoveryComplete();
                }
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void recoveryComplete() {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                this.recoveryState.clear();
                this.eventAdmin.postEvent(new Event(TOPIC_RECOVERY_COMPLETED, null));
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean isRecoveryEnabled() {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                boolean bl = Boolean.valueOf(FrameworkUtil.getBundle(this.getClass()).getBundleContext().getProperty("org.eclipse.virgo.kernel.deployer.disableRecovery")) == false;
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return bl;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void handleEvent(Event event) {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                if (TOPIC_SYSTEM_ARTIFACTS_DEPLOYED.equals(event.getTopic())) {
                    this.performRecovery();
                }
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ void access$0(RecoveryAgent arg0) {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                arg0.recoveryComplete();
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ Map access$1(RecoveryAgent arg0) {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                Map<URI, ApplicationDeployer.DeploymentOptions> map = arg0.recoveryState;
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return map;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ ApplicationRecoverer access$2(RecoveryAgent arg0) {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                ApplicationRecoverer applicationRecoverer = arg0.recoverer;
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return applicationRecoverer;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static /* synthetic */ EventLogger access$3(RecoveryAgent arg0) {
        try {
            try {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                EventLogger eventLogger = arg0.eventLogger;
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return eventLogger;
            }
            catch (Throwable throwable) {
                RecoveryAgent.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("RecoveryAgent.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "performRecovery", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "", "", "", "void"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "recoveryComplete", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "", "", "", "void"), 90);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isRecoveryEnabled", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "", "", "", "boolean"), 95);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleEvent", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "org.osgi.service.event.Event:", "event:", "", "void"), 102);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent:", "arg0:", "", "void"), 89);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent:", "arg0:", "", "java.util.Map"), 53);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$2", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent:", "arg0:", "", "org.eclipse.virgo.kernel.deployer.core.internal.ApplicationRecoverer"), 47);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$3", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent", "org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent:", "arg0:", "", "org.eclipse.virgo.medic.eventlog.EventLogger"), 49);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.recovery.RecoveryAgent");
    }
}

