/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.virgo.util.osgi.manifest.Parameterised;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseParameterised
implements Parameterised {
    protected String name;
    private final HeaderParser parser;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, String> directives = new HashMap<String, String>();
    private static final String EMPTY_STRING = "";

    BaseParameterised(HeaderParser parser) {
        this.parser = parser;
    }

    @Override
    public void resetFromParseString(String string) {
        HeaderDeclaration header = this.parse(this.parser, string);
        this.name = header.getNames().get(0);
        this.attributes = header.getAttributes();
        this.directives = header.getDirectives();
    }

    abstract HeaderDeclaration parse(HeaderParser var1, String var2);

    @Override
    public String toParseString() {
        if (this.name == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        BaseParameterised.writeMap(this.attributes, sb, "=");
        BaseParameterised.writeMap(this.directives, sb, ":=");
        return sb.toString();
    }

    public String toString() {
        String parseString = this.toParseString();
        if (parseString == null) {
            return EMPTY_STRING;
        }
        return parseString;
    }

    private static void writeMap(Map<String, String> map, StringBuilder sb, String delimiter) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(";").append(entry.getKey()).append(delimiter).append("\"").append(entry.getValue()).append("\"");
        }
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.directives.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseParameterised other = (BaseParameterised)obj;
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        if (!this.directives.equals(other.directives)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

