/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.beans.PropertyChangeListener;
import javax.management.MBeanRegistration;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.tomcat.util.modeler.Registry;
import org.eclipse.gemini.web.tomcat.internal.loading.BaseWebappLoader;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleWebappClassLoader;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.osgi.framework.Bundle;

public class BundleWebappLoader
extends BaseWebappLoader
implements Loader,
Lifecycle,
PropertyChangeListener,
MBeanRegistration {
    private static Log log = LogFactory.getLog(BundleWebappLoader.class);
    private volatile Bundle bundle;
    private volatile ClassLoaderCustomizer classLoaderCustomizer;
    private long bundleModificationCheckTimestamp;
    private Object bundleModificationLock = new Object();
    private ClassLoader classLoader = null;
    private static final String INFO = String.valueOf(BaseWebappLoader.class.getName()) + "/1.0";
    private boolean started = false;

    public BundleWebappLoader(Bundle bundle, ClassLoaderCustomizer classLoaderCustomizer) {
        this.bundle = bundle;
        this.bundleModificationCheckTimestamp = this.bundle.getLastModified();
        this.classLoaderCustomizer = classLoaderCustomizer;
    }

    private ClassLoader createClassLoader() {
        return new BundleWebappClassLoader(this.bundle, this.classLoaderCustomizer);
    }

    public void addRepository(String repository) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support addRepository(String)");
    }

    public String[] findRepositories() {
        return new String[0];
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getInfo() {
        return INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modified() {
        Object object = this.bundleModificationLock;
        synchronized (object) {
            block4: {
                long lastModified = this.bundle.getLastModified();
                if (lastModified <= this.bundleModificationCheckTimestamp) break block4;
                this.bundleModificationCheckTimestamp = lastModified;
                return true;
            }
        }
        return false;
    }

    public void start() throws LifecycleException {
        this.init();
        if (this.started) {
            throw new LifecycleException(sm.getString("webappLoader.alreadyStarted"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.getContainer().getResources() == null) {
            log.info((Object)("No resources for " + this.getContainer()));
            return;
        }
        try {
            this.classLoader = this.createClassLoader();
            if (this.classLoader instanceof Lifecycle) {
                ((Lifecycle)this.classLoader).start();
            }
            DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)this.getContainer().getResources());
            this.registerClassLoaderMBean();
        }
        catch (Throwable t) {
            log.error((Object)"LifecycleException ", t);
            throw new LifecycleException("start: ", t);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("webappLoader.notStarted"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.getContainer() instanceof Context) {
            ServletContext servletContext = ((Context)this.getContainer()).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader instanceof Lifecycle) {
            ((Lifecycle)this.classLoader).stop();
        }
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        this.unregisterClassLoaderMBean();
        this.classLoader = null;
        this.bundle = null;
        this.classLoaderCustomizer = null;
        this.destroy();
    }

    private void registerClassLoaderMBean() throws MalformedObjectNameException, Exception {
        StandardContext ctx = (StandardContext)this.getContainer();
        this.ensureGrandparentIsAnEngine(ctx);
        ObjectName classLoaderObjectName = this.createClassLoaderObjectName(ctx);
        Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, classLoaderObjectName, null);
    }

    private void unregisterClassLoaderMBean() {
        try {
            StandardContext ctx = (StandardContext)this.getContainer();
            this.ensureGrandparentIsAnEngine(ctx);
            ObjectName classLoaderObjectName = this.createClassLoaderObjectName(ctx);
            Registry.getRegistry(null, null).unregisterComponent(classLoaderObjectName);
        }
        catch (Throwable t) {
            log.error((Object)"LifecycleException ", t);
        }
    }

    private ObjectName createClassLoaderObjectName(StandardContext ctx) throws MalformedObjectNameException {
        return new ObjectName(String.valueOf(ctx.getEngineName()) + ":type=OsgiWebappClassLoader,path=" + this.getCatalinaContextPath(ctx) + ",host=" + ctx.getParent().getName());
    }
}

