/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.beans.Introspector;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.openejb.core.TempClassLoader;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.UrlCache;

public class ClassLoaderUtil {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, ClassLoaderUtil.class);
    private static final Map<String, List<ClassLoader>> classLoadersByApp = new HashMap<String, List<ClassLoader>>();
    private static final Map<ClassLoader, Set<String>> appsByClassLoader = new HashMap<ClassLoader, Set<String>>();
    private static final UrlCache localUrlCache = new UrlCache();

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static File getUrlCachedName(String appId, URL url) {
        return localUrlCache.getUrlCachedName(appId, url);
    }

    public static boolean isUrlCached(String appId, URL url) {
        return localUrlCache.isUrlCached(appId, url);
    }

    public static URL getUrlKeyCached(String appId, File file) {
        return localUrlCache.getUrlKeyCached(appId, file);
    }

    public static URLClassLoader createClassLoader(String appId, URL[] urls, ClassLoader parent) {
        urls = localUrlCache.cacheUrls(appId, urls);
        URLClassLoader classLoader = new URLClassLoader(urls, parent);
        List<ClassLoader> classLoaders = classLoadersByApp.get(appId);
        if (classLoaders == null) {
            classLoaders = new ArrayList<ClassLoader>(2);
            classLoadersByApp.put(appId, classLoaders);
        }
        classLoaders.add(classLoader);
        Set<String> apps = appsByClassLoader.get(classLoader);
        if (apps == null) {
            apps = new LinkedHashSet<String>(1);
            appsByClassLoader.put(classLoader, apps);
        }
        apps.add(appId);
        return classLoader;
    }

    public static void destroyClassLoader(ClassLoader classLoader) {
        logger.debug("Destroying classLoader " + ClassLoaderUtil.toString(classLoader));
        Set<String> apps = appsByClassLoader.remove(classLoader);
        if (apps != null) {
            for (String appId : apps) {
                List<ClassLoader> classLoaders = classLoadersByApp.get(appId);
                if (classLoaders != null) {
                    classLoaders.remove(classLoader);
                }
                if (null != classLoaders && !classLoaders.isEmpty()) continue;
                ClassLoaderUtil.destroyClassLoader(appId);
            }
        }
        ClassLoaderUtil.cleanOpenJPACache(classLoader);
        for (String jar : ClassLoaderUtil.getClosedJarFiles(classLoader)) {
            ClassLoaderUtil.clearSunJarFileFactoryCache(jar);
        }
        classLoader = null;
    }

    private static List<String> getClosedJarFiles(ClassLoader cl) {
        ArrayList<String> files = new ArrayList<String>();
        if (null != cl && cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            Class<URLClassLoader> clazz = URLClassLoader.class;
            try {
                Field ucp = clazz.getDeclaredField("ucp");
                ucp.setAccessible(true);
                Object cp = ucp.get(ucl);
                Field loaders = cp.getClass().getDeclaredField("loaders");
                loaders.setAccessible(true);
                Collection c = (Collection)loaders.get(cp);
                for (Object jl : c.toArray()) {
                    try {
                        Field loader = jl.getClass().getDeclaredField("jar");
                        loader.setAccessible(true);
                        JarFile jf = (JarFile)loader.get(jl);
                        files.add(jf.getName());
                        jf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return files;
    }

    public boolean finalizeNativeLibs(ClassLoader cl) {
        boolean res = false;
        Class<ClassLoader> classClassLoader = ClassLoader.class;
        Field nativeLibraries = null;
        try {
            nativeLibraries = classClassLoader.getDeclaredField("nativeLibraries");
        }
        catch (NoSuchFieldException e1) {
            // empty catch block
        }
        if (nativeLibraries == null) {
            return res;
        }
        nativeLibraries.setAccessible(true);
        Object obj = null;
        try {
            obj = nativeLibraries.get(cl);
        }
        catch (IllegalAccessException e1) {
            // empty catch block
        }
        if (!(obj instanceof Vector)) {
            return res;
        }
        res = true;
        Vector java_lang_ClassLoader_NativeLibrary = (Vector)obj;
        for (Object lib : java_lang_ClassLoader_NativeLibrary) {
            Method finalize = null;
            try {
                finalize = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                if (finalize == null) continue;
                finalize.setAccessible(true);
                try {
                    finalize.invoke(lib, new Object[0]);
                }
                catch (Throwable e) {
                }
            }
            catch (Throwable e) {}
        }
        return res;
    }

    public static void destroyClassLoader(String appId) {
        logger.debug("Destroying classLoaders for application " + appId);
        List<ClassLoader> classLoaders = classLoadersByApp.remove(appId);
        if (classLoaders != null) {
            Iterator<ClassLoader> it = classLoaders.iterator();
            while (it.hasNext()) {
                ClassLoader cl = it.next();
                Set<String> apps = appsByClassLoader.get(cl);
                if (null != apps) {
                    apps.remove(appId);
                }
                if (null == apps || apps.isEmpty()) {
                    it.remove();
                    appsByClassLoader.remove(cl);
                    ClassLoaderUtil.destroyClassLoader(cl);
                    cl = null;
                    System.gc();
                    continue;
                }
                logger.debug("ClassLoader " + ClassLoaderUtil.toString(cl) + " held open by the applications: " + apps);
            }
        }
        localUrlCache.releaseUrls(appId);
        ClassLoaderUtil.clearSunJarFileFactoryCache(appId);
    }

    public static URLClassLoader createTempClassLoader(ClassLoader parent) {
        return new TempClassLoader(parent);
    }

    public static URLClassLoader createTempClassLoader(String appId, URL[] urls, ClassLoader parent) {
        URLClassLoader classLoader = ClassLoaderUtil.createClassLoader(appId, urls, parent);
        return new TempClassLoader(classLoader);
    }

    public static void clearClassLoaderCaches() {
        ClassLoaderUtil.clearSunSoftCache(ObjectInputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectOutputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "localDescs");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "reflectors");
        Introspector.flushCaches();
    }

    public static void clearSunJarFileFactoryCache(String jarLocation) {
        ClassLoaderUtil.clearSunJarFileFactoryCacheImpl(jarLocation, 5);
    }

    private static synchronized void clearSunJarFileFactoryCacheImpl(String jarLocation, int attempt) {
        logger.debug("Clearing Sun JarFileFactory cache for directory " + jarLocation);
        try {
            Object remove;
            Class<?> jarFileFactory = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            Field fileCacheField = jarFileFactory.getDeclaredField("fileCache");
            fileCacheField.setAccessible(true);
            Map fileCache = (Map)fileCacheField.get(null);
            HashMap fileCacheCopy = new HashMap(fileCache);
            Field urlCacheField = jarFileFactory.getDeclaredField("urlCache");
            urlCacheField.setAccessible(true);
            Map urlCache = (Map)urlCacheField.get(null);
            HashMap urlCacheCopy = new HashMap(urlCache);
            Iterator iterator = urlCacheCopy.entrySet().iterator();
            ArrayList urlCacheRemoveKeys = new ArrayList();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                if (key instanceof ZipFile) {
                    ZipFile zf = (ZipFile)key;
                    File file = new File(zf.getName());
                    if (!ClassLoaderUtil.isParent(jarLocation, file)) continue;
                    urlCacheRemoveKeys.add(key);
                    continue;
                }
                logger.warning("Unexpected key type: " + key);
            }
            iterator = fileCacheCopy.entrySet().iterator();
            ArrayList fileCacheRemoveKeys = new ArrayList();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object value = entry.getValue();
                if (!urlCacheRemoveKeys.contains(value)) continue;
                fileCacheRemoveKeys.add(entry.getKey());
            }
            for (Map.Entry next : fileCacheRemoveKeys) {
                try {
                    remove = fileCache.remove(next);
                    if (null == remove) continue;
                    logger.debug("Removed item from fileCache: " + remove);
                }
                catch (Throwable e) {
                    logger.warning("Failed to remove item from fileCache: " + next);
                }
            }
            for (Map.Entry next : urlCacheRemoveKeys) {
                try {
                    remove = urlCache.remove(next);
                    try {
                        ((ZipFile)((Object)next)).close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (null == remove) continue;
                    logger.debug("Removed item from urlCache: " + remove);
                }
                catch (Throwable e) {
                    logger.warning("Failed to remove item from urlCache: " + next);
                }
            }
        }
        catch (ConcurrentModificationException e) {
            if (attempt > 0) {
                ClassLoaderUtil.clearSunJarFileFactoryCacheImpl(jarLocation, attempt - 1);
            } else {
                logger.error("Unable to clear Sun JarFileFactory cache after 5 attempts", e);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (Throwable e) {
            logger.error("Unable to clear Sun JarFileFactory cache", e);
        }
    }

    private static boolean isParent(String jarLocation, File file) {
        File dir = new File(jarLocation);
        while (file != null) {
            if (file.equals(dir)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSunSoftCache(Class clazz, String fieldName) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                Map cache = (Map)field.get(null);
                cache.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void cleanOpenJPACache(ClassLoader classLoader) {
        try {
            Class<?> pcRegistryClass = ClassLoaderUtil.class.getClassLoader().loadClass("org.apache.openjpa.enhance.PCRegistry");
            Method deRegisterMethod = pcRegistryClass.getMethod("deRegister", ClassLoader.class);
            deRegisterMethod.invoke(null, classLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String toString(ClassLoader classLoader) {
        if (classLoader == null) {
            return "null";
        }
        return classLoader.getClass().getSimpleName() + "@" + System.identityHashCode(classLoader);
    }
}

