/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import org.eclipse.equinox.http.Registration;
import org.eclipse.equinox.http.servlet.HttpServletRequestImpl;
import org.eclipse.equinox.http.servlet.HttpServletResponseImpl;
import org.eclipse.equinox.http.servlet.ServletContextImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ServletRegistration
implements Registration {
    protected Bundle bundle;
    protected HttpContext httpContext;
    protected String alias;
    protected Servlet servlet;
    protected ServletContextImpl servletContext;
    protected AccessControlContext accessControlContext;

    protected ServletRegistration(Bundle bundle, String alias, Servlet servlet, HttpContext httpContext, ServletContextImpl servletContext) {
        this.bundle = bundle;
        this.alias = alias;
        this.servlet = servlet;
        this.httpContext = httpContext;
        this.servletContext = servletContext;
        this.accessControlContext = AccessController.getContext();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void destroy() {
        if (this.servlet != null) {
            this.servlet.destroy();
        }
        this.alias = null;
        this.servlet = null;
    }

    public String getAlias() {
        return this.alias;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void service(HttpServletRequestImpl request, HttpServletResponseImpl response) throws ServletException, IOException {
        request.init(this.alias, this.servletContext);
        this.service((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.servlet instanceof SingleThreadModel) {
            ServletRegistration servletRegistration = this;
            synchronized (servletRegistration) {
                this.servlet.service(request, response);
            }
        } else {
            this.servlet.service(request, response);
        }
    }
}

