/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security;

import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.core.security.jaas.UsernamePasswordCallbackHandler;
import org.apache.openejb.core.security.jacc.BasicJaccProvider;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.ConfUtils;

public class SecurityServiceImpl
extends AbstractSecurityService {
    private static final Map<Object, LoginContext> contexts = new ConcurrentHashMap<Object, LoginContext>();

    public SecurityServiceImpl() {
        this(BasicJaccProvider.class.getName());
    }

    public SecurityServiceImpl(String jaccProviderClass) {
        super(jaccProviderClass);
        SecurityServiceImpl.installJaas();
        try {
            this.login("", "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void installJaas() {
        String path = SystemInstance.get().getOptions().get("java.security.auth.login.config", (String)null);
        if (path != null) {
            return;
        }
        URL loginConfig = ConfUtils.getConfResource("login.config");
        System.setProperty("java.security.auth.login.config", URLDecoder.decode(loginConfig.toExternalForm()));
    }

    @Override
    public UUID login(String realmName, String username, String password) throws LoginException {
        if (realmName == null) {
            realmName = this.getRealmName();
        }
        LoginContext context = new LoginContext(realmName, new UsernamePasswordCallbackHandler(username, password));
        context.login();
        Subject subject = context.getSubject();
        UUID token = this.registerSubject(subject);
        contexts.put(token, context);
        return token;
    }

    @Override
    public void logout(UUID securityIdentity) throws LoginException {
        LoginContext context = contexts.get(securityIdentity);
        if (null == context) {
            throw new IllegalStateException("Unable to logout. Can not recover LoginContext.");
        }
        context.logout();
        super.logout(securityIdentity);
    }
}

