/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.IListChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListChangeEvent<T>
implements IListChangeEvent<T> {
    private int endIndex;
    private IListChangeEvent.EventType eventType;
    private List<? extends T> items;
    private List<? extends T> list;
    private String listName;
    private StateObject source;
    private int startIndex;

    public ListChangeEvent(StateObject source, List<? extends T> list, IListChangeEvent.EventType eventType, String listName, List<? extends T> items, int startIndex, int endIndex) {
        this.list = list;
        this.items = items;
        this.source = source;
        this.endIndex = endIndex;
        this.listName = listName;
        this.eventType = eventType;
        this.startIndex = startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public IListChangeEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public List<T> getList() {
        return this.list;
    }

    @Override
    public String getListName() {
        return this.listName;
    }

    @Override
    public <S extends ListHolderStateObject<? extends T>> S getSource() {
        return (S)((ListHolderStateObject)this.source);
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public IterableListIterator<T> items() {
        return new CloneListIterator<T>(this.items);
    }

    @Override
    public int itemsSize() {
        return this.items.size();
    }
}

