/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.urlhandling;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.epp.internal.mpc.ui.urlhandling.AbstractMpcProtocolUrlHandler;
import org.eclipse.epp.internal.mpc.ui.urlhandling.FavoritesUrlHandler;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;

public class MpcProtocolFavoritesUrlHandler
extends AbstractMpcProtocolUrlHandler
implements FavoritesUrlHandler {
    private static final String IMPORT_FAVORITES_ACTION = "favorites";
    private static final String FAVORITES_URL_PATTERN = "%s/user/%s/favorites";

    @Override
    public boolean isPotentialFavoritesList(String url) {
        return url.contains("/favorites/");
    }

    @Override
    public MarketplaceUrlHandler.FavoritesDescriptor parse(String url) {
        String favoriteListId;
        Map<String, Object> properties = this.doParse(url);
        if (properties == null || !IMPORT_FAVORITES_ACTION.equals(properties.get("action"))) {
            return null;
        }
        IPath itemPath = (IPath)properties.get("path_parameters");
        String string = favoriteListId = itemPath == null ? null : itemPath.toString();
        if (favoriteListId != null) {
            String favoritesUrl = String.format(FAVORITES_URL_PATTERN, ((URL)properties.get("marketplace_url")).toString(), favoriteListId);
            CatalogDescriptor descriptor = (CatalogDescriptor)properties.get("mpc_catalog");
            return new MarketplaceUrlHandler.FavoritesDescriptor(favoritesUrl, descriptor);
        }
        return null;
    }
}

