/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.signing.GpgConfigurationException;
import org.eclipse.egit.core.internal.signing.GpgSetup;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.team.core.TeamException;

public class RewordCommitOperation
implements IEGitOperation {
    private Repository repository;
    private RevCommit commit;
    private String newMessage;
    private ObjectId headId;

    public RewordCommitOperation(Repository repository, RevCommit commit, String newMessage) {
        this.repository = repository;
        this.commit = commit;
        this.newMessage = newMessage;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk walk = new RevWalk(this.repository);){
                DirCache index = this.repository.lockDirCache();
                try {
                    this.reword(monitor, walk);
                }
                finally {
                    index.unlock();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GpgConfigurationException e) {
            throw new TeamException(e.getMessage(), (Throwable)e);
        }
    }

    private void reword(IProgressMonitor monitor, RevWalk walk) throws IOException, CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(CoreText.RewordCommitOperation_rewording, Utils.getShortObjectId((ObjectId)this.commit)), (int)100);
        this.commit = walk.parseCommit((AnyObjectId)this.commit);
        if (this.newMessage.equals(this.commit.getFullMessage())) {
            return;
        }
        Ref ref = this.repository.exactRef("HEAD");
        if (ref == null) {
            throw new TeamException(CoreText.RewordCommitOperation_noHead);
        }
        this.headId = ref.getObjectId();
        if (this.headId == null || ObjectId.zeroId().equals((AnyObjectId)this.headId)) {
            throw new TeamException(CoreText.RewordCommitOperation_noHead);
        }
        String headName = ref.isSymbolic() ? ref.getLeaf().getName() : this.headId.name();
        LinkedList<RevCommit> commits = new LinkedList<RevCommit>();
        walk.setRetainBody(true);
        if (!this.commit.getId().equals((AnyObjectId)this.headId)) {
            RevCommit c;
            walk.sort(RevSort.TOPO);
            walk.sort(RevSort.COMMIT_TIME_DESC, true);
            walk.markStart(walk.parseCommit((AnyObjectId)this.headId));
            RevCommit[] revCommitArray = this.commit.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                RevCommit parsed = walk.parseCommit((AnyObjectId)p);
                walk.markUninteresting(parsed);
                ++n2;
            }
            while ((c = walk.next()) != null) {
                if (c.getId().equals((AnyObjectId)this.commit.getId())) break;
                commits.push(c);
            }
            if (c == null) {
                throw new TeamException(MessageFormat.format(CoreText.RewordCommitOperation_notReachable, Utils.getShortObjectId((ObjectId)this.commit)));
            }
        }
        progress.worked(10);
        progress.setWorkRemaining(commits.size() + 2);
        PersonIdent committer = new PersonIdent(this.repository);
        CommitBuilder builder = this.copy(this.commit, (ObjectId[])this.commit.getParents(), committer, this.newMessage);
        final File gpgProgram = GitSettings.getGpgExecutable();
        GpgConfig gpgConfig = new GpgConfig((Config)this.repository.getConfig()){

            public String getProgram() {
                return gpgProgram != null ? gpgProgram.getAbsolutePath() : super.getProgram();
            }
        };
        boolean signAllCommits = gpgConfig.isSignCommits();
        GpgSigner gpgSigner = GpgSetup.getDefault();
        if (gpgSigner != null && (signAllCommits || this.commit.getRawGpgSignature() != null)) {
            gpgSigner = this.sign(builder, gpgSigner, gpgConfig, committer, this.commit);
        }
        HashMap<ObjectId, ObjectId> rewritten = new HashMap<ObjectId, ObjectId>();
        String newCommitId = null;
        Throwable throwable = null;
        Object var16_20 = null;
        try (ObjectInserter inserter = this.repository.newObjectInserter();){
            ObjectId newCommit = inserter.insert(builder);
            rewritten.put(this.commit.getId(), newCommit);
            newCommitId = newCommit.name();
            progress.worked(1);
            for (RevCommit c : commits) {
                RevCommit[] parents = c.getParents();
                ObjectId[] newParents = new ObjectId[parents.length];
                int i = 0;
                boolean hadNew = false;
                RevCommit[] revCommitArray = parents;
                int n = parents.length;
                int n3 = 0;
                while (n3 < n) {
                    RevCommit p = revCommitArray[n3];
                    ObjectId newId = (ObjectId)rewritten.get(p.getId());
                    if (newId != null) {
                        hadNew = true;
                    }
                    newParents[i++] = newId != null ? newId : p.getId();
                    ++n3;
                }
                if (!hadNew) continue;
                committer = new PersonIdent(committer);
                builder = this.copy(c, newParents, committer, c.getFullMessage());
                if (gpgSigner != null && (signAllCommits || c.getRawGpgSignature() != null)) {
                    gpgSigner = this.sign(builder, gpgSigner, gpgConfig, committer, c);
                }
                rewritten.put(c.getId(), inserter.insert(builder));
                progress.worked(1);
            }
            inserter.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ObjectId newHeadId = (ObjectId)rewritten.get(this.headId);
        RefUpdate ru = this.repository.updateRef("HEAD");
        ru.setExpectedOldObjectId((AnyObjectId)this.headId);
        ru.setNewObjectId((AnyObjectId)newHeadId);
        ru.setForceUpdate(true);
        ru.setRefLogMessage("rebase finished: returning to " + headName + " after having reworded commit " + newCommitId, false);
        switch (ru.update(walk)) {
            case NO_CHANGE: 
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                break;
            }
            default: {
                throw new TeamException(MessageFormat.format(CoreText.RewordCommitOperation_cannotUpdateHead, Utils.getShortObjectId((ObjectId)this.commit)));
            }
        }
        ObjectId origHead = ru.getOldObjectId();
        if (origHead != null) {
            this.repository.writeOrigHead(origHead);
        }
        progress.worked(1);
    }

    private CommitBuilder copy(RevCommit toCopy, ObjectId[] parents, PersonIdent committer, String message) {
        CommitBuilder builder = new CommitBuilder();
        builder.setParentIds(parents);
        builder.setAuthor(toCopy.getAuthorIdent());
        builder.setCommitter(committer);
        builder.setEncoding(toCopy.getEncoding());
        builder.setTreeId((AnyObjectId)toCopy.getTree());
        builder.setMessage(message);
        return builder;
    }

    private GpgSigner sign(CommitBuilder builder, GpgSigner signer, GpgConfig config, PersonIdent committer, RevCommit original) throws JGitInternalException {
        PersonIdent oldCommitter = original.getCommitterIdent();
        if (committer.getName().equals(oldCommitter.getName()) && committer.getEmailAddress().equals(oldCommitter.getEmailAddress())) {
            try {
                if (signer instanceof GpgObjectSigner) {
                    ((GpgObjectSigner)signer).signObject((ObjectBuilder)builder, config.getSigningKey(), committer, CredentialsProvider.getDefault(), config);
                } else {
                    signer.sign(builder, config.getSigningKey(), committer, CredentialsProvider.getDefault());
                }
            }
            catch (CanceledException e) {
                return null;
            }
            catch (JGitInternalException | UnsupportedSigningFormatException e) {
                if (config.isSignCommits()) {
                    if (e instanceof JGitInternalException) {
                        throw (JGitInternalException)e;
                    }
                    throw new JGitInternalException(e.getMessage(), e);
                }
                Activator.logWarning(MessageFormat.format(CoreText.RewordCommitOperation_cannotSign, Utils.getShortObjectId((ObjectId)this.commit), Utils.getShortObjectId(this.headId), Utils.getShortObjectId((ObjectId)original)), e);
                return null;
            }
        }
        return signer;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

