/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent.connector;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.PageantConnector;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.UnixDomainSocketConnector;
import org.eclipse.jgit.transport.sshd.agent.Connector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.SystemReader;

public class Factory
implements ConnectorFactory {
    private static final String NAME = "jgit-builtin";

    public Connector create(String identityAgent, File homeDir) throws IOException {
        if (SystemReader.getInstance().isWindows()) {
            return new PageantConnector();
        }
        return new UnixDomainSocketConnector(identityAgent);
    }

    public boolean isSupported() {
        return true;
    }

    public String getName() {
        return NAME;
    }

    public Collection<ConnectorFactory.ConnectorDescriptor> getSupportedConnectors() {
        return Collections.singleton(this.getDefaultConnector());
    }

    public ConnectorFactory.ConnectorDescriptor getDefaultConnector() {
        if (SystemReader.getInstance().isWindows()) {
            return PageantConnector.DESCRIPTOR;
        }
        return UnixDomainSocketConnector.DESCRIPTOR;
    }
}

