/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.wst.internet.monitor.core.internal.Connection;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class TCPIPThread
extends Thread {
    private static final int BUFFER = 2048;
    protected InputStream in;
    protected OutputStream out;
    protected boolean isRequest;
    protected Connection conn;
    protected Request request;

    public TCPIPThread(Connection conn, Request request, InputStream in, OutputStream out, boolean isRequest) {
        super("TCP/IP Monitor TCP/IP Connection");
        this.conn = conn;
        this.request = request;
        this.in = in;
        this.out = out;
        this.isRequest = isRequest;
        this.setPriority(6);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            try {
                byte[] b = new byte[2048];
                int n = this.in.read(b);
                while (n > 0) {
                    this.out.write(b, 0, n);
                    if (b != null && n > 0) {
                        byte[] x = null;
                        if (n == 2048) {
                            x = b;
                        } else {
                            x = new byte[n];
                            System.arraycopy(b, 0, x, 0, n);
                        }
                        if (this.isRequest) {
                            this.request.addToRequest(x);
                        } else {
                            this.request.addToResponse(x);
                        }
                    }
                    n = this.in.read(b);
                    Thread.yield();
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                if (!this.isRequest) {
                    this.conn.close();
                }
            }
        }
        finally {
            if (!this.isRequest) {
                this.conn.close();
            }
        }
    }
}

