/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.diffmergetool;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.internal.diffmergetool.CommandLineDiffTool;
import org.eclipse.jgit.internal.diffmergetool.DiffToolConfig;
import org.eclipse.jgit.internal.diffmergetool.ExternalDiffTool;
import org.eclipse.jgit.internal.diffmergetool.PreDefinedDiffTool;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.internal.BooleanTriState;

public class DiffTools {
    private final DiffToolConfig config;
    private Map<String, ExternalDiffTool> predefinedTools;
    private Map<String, ExternalDiffTool> userDefinedTools;

    public DiffTools(Repository repo) {
        this.config = repo.getConfig().get(DiffToolConfig.KEY);
        this.setupPredefinedTools();
        this.setupUserDefinedTools();
    }

    public int compare(String newPath, String oldPath, String newId, String oldId, String toolName, BooleanTriState prompt, BooleanTriState gui, BooleanTriState trustExitCode) {
        return 0;
    }

    public Set<String> getToolNames() {
        return this.config.getToolNames();
    }

    public Map<String, ExternalDiffTool> getUserDefinedTools() {
        return Collections.unmodifiableMap(this.userDefinedTools);
    }

    public Map<String, ExternalDiffTool> getAvailableTools() {
        return Collections.unmodifiableMap(this.predefinedTools);
    }

    public Map<String, ExternalDiffTool> getNotAvailableTools() {
        return Collections.unmodifiableMap(new TreeMap());
    }

    public String getDefaultToolName(BooleanTriState gui) {
        return gui != BooleanTriState.UNSET ? "my_gui_tool" : "my_default_toolname";
    }

    public boolean isInteractive() {
        return false;
    }

    private void setupPredefinedTools() {
        this.predefinedTools = new TreeMap<String, ExternalDiffTool>();
        CommandLineDiffTool[] commandLineDiffToolArray = CommandLineDiffTool.values();
        int n = commandLineDiffToolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandLineDiffTool tool = commandLineDiffToolArray[n2];
            this.predefinedTools.put(tool.name(), new PreDefinedDiffTool(tool));
            ++n2;
        }
    }

    private void setupUserDefinedTools() {
        this.userDefinedTools = new TreeMap<String, ExternalDiffTool>();
        Map<String, ExternalDiffTool> userTools = this.config.getTools();
        for (String name : userTools.keySet()) {
            PreDefinedDiffTool predefTool;
            ExternalDiffTool userTool = userTools.get(name);
            if (userTool.getCommand() != null) {
                this.userDefinedTools.put(name, userTool);
                continue;
            }
            if (userTool.getPath() == null || (predefTool = (PreDefinedDiffTool)this.predefinedTools.get(name)) == null) continue;
            predefTool.setPath(userTool.getPath());
        }
    }
}

