/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4e.operations.completion.CompletionProposalTools;
import org.eclipse.lsp4e.operations.hover.FocusableBrowserInformationControl;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LSIncompleteCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6,
ICompletionProposalExtension7,
IContextInformation {
    private static final int RESOLVE_TIMEOUT = 500;
    private static final String TM_SELECTED_TEXT = "TM_SELECTED_TEXT";
    private static final String TM_CURRENT_LINE = "TM_CURRENT_LINE";
    private static final String TM_CURRENT_WORD = "TM_CURRENT_WORD";
    private static final String TM_LINE_INDEX = "TM_LINE_INDEX";
    private static final String TM_LINE_NUMBER = "TM_LINE_NUMBER";
    private static final String TM_FILENAME = "TM_FILENAME";
    private static final String TM_FILENAME_BASE = "TM_FILENAME_BASE";
    private static final String TM_DIRECTORY = "TM_DIRECTORY";
    private static final String TM_FILEPATH = "TM_FILEPATH";
    private static final StyledString.Styler DEPRECATE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.strikeout = true;
            textStyle.foreground = PlatformUI.getWorkbench().getDisplay().getSystemColor(16);
        }
    };
    protected final CompletionItem item;
    private int initialOffset = -1;
    protected int bestOffset = -1;
    protected int currentOffset = -1;
    protected ITextViewer viewer;
    private final IDocument document;
    private IRegion selection;
    private LinkedPosition firstPosition;
    private Integer rankCategory;
    private Integer rankScore;
    private String documentFilter;
    private String documentFilterAddition = "";
    private final LanguageServer languageServer;

    public LSIncompleteCompletionProposal(@NonNull IDocument document, int offset, @NonNull CompletionItem item, LanguageServer languageServer) {
        this.item = item;
        this.document = document;
        this.languageServer = languageServer;
        this.initialOffset = offset;
        this.currentOffset = offset;
        this.bestOffset = this.getPrefixCompletionStart(document, offset);
    }

    public String getDocumentFilter(int offset) throws BadLocationException {
        if (this.documentFilter != null) {
            if (offset != this.currentOffset) {
                this.documentFilterAddition = this.document.get(this.initialOffset, offset - this.initialOffset);
                this.rankScore = null;
                this.rankCategory = null;
                this.currentOffset = offset;
            }
            return String.valueOf(this.documentFilter) + this.documentFilterAddition;
        }
        this.currentOffset = offset;
        return this.getDocumentFilter();
    }

    public String getDocumentFilter() throws BadLocationException {
        if (this.documentFilter != null) {
            return String.valueOf(this.documentFilter) + this.documentFilterAddition;
        }
        this.documentFilter = CompletionProposalTools.getFilterFromDocument(this.document, this.currentOffset, this.getFilterString(), this.bestOffset);
        this.documentFilterAddition = "";
        return this.documentFilter;
    }

    public int getRankScore() {
        if (this.rankScore != null) {
            return this.rankScore;
        }
        try {
            this.rankScore = CompletionProposalTools.getScoreOfFilterMatch(this.getDocumentFilter(), this.getFilterString());
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            this.rankScore = -1;
        }
        return this.rankScore;
    }

    public int getRankCategory() {
        if (this.rankCategory != null) {
            return this.rankCategory;
        }
        try {
            this.rankCategory = CompletionProposalTools.getCategoryOfFilterMatch(this.getDocumentFilter(), this.getFilterString());
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            this.rankCategory = 5;
        }
        return this.rankCategory;
    }

    public int getBestOffset() {
        return this.bestOffset;
    }

    public void updateOffset(int offset) {
        this.bestOffset = this.getPrefixCompletionStart(this.document, offset);
    }

    public CompletionItem getItem() {
        return this.item;
    }

    private boolean isDeprecated() {
        return this.item.getDeprecated() != null && this.item.getDeprecated() != false;
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, final BoldStylerProvider boldStylerProvider) {
        StyledString res;
        String rawString = this.getDisplayString();
        StyledString styledString = res = this.isDeprecated() ? new StyledString(rawString, DEPRECATE) : new StyledString(rawString);
        if (offset > this.bestOffset) {
            try {
                String subString = this.getDocumentFilter(offset).toLowerCase();
                int lastIndex = 0;
                String lowerRawString = rawString.toLowerCase();
                char[] cArray = subString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Character c = Character.valueOf(cArray[n2]);
                    int index = lowerRawString.indexOf(c.charValue(), lastIndex);
                    if (index < 0) {
                        return res;
                    }
                    res.setStyle(index, 1, new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            if (LSIncompleteCompletionProposal.this.isDeprecated()) {
                                DEPRECATE.applyStyles(textStyle);
                            }
                            boldStylerProvider.getBoldStyler().applyStyles(textStyle);
                        }
                    });
                    lastIndex = index + 1;
                    ++n2;
                }
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return res;
    }

    public String getDisplayString() {
        return this.item.getLabel();
    }

    public StyledString getStyledDisplayString() {
        if (Boolean.TRUE.equals(this.item.getDeprecated())) {
            return new StyledString(this.getDisplayString(), DEPRECATE);
        }
        return new StyledString(this.getDisplayString());
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent);
            }
        };
    }

    public String getAdditionalProposalInfo(IProgressMonitor monitor) {
        String htmlDocString;
        if (LanguageServiceAccessor.checkCapability(this.languageServer, capability -> Boolean.TRUE.equals(capability.getCompletionProvider().getResolveProvider()))) {
            try {
                ((CompletableFuture)this.languageServer.getTextDocumentService().resolveCompletionItem(this.item).thenAcceptAsync(this::updateCompletionItem)).get(500L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
        }
        StringBuilder res = new StringBuilder();
        if (this.item.getDetail() != null && !this.item.getDetail().isEmpty()) {
            res.append("<p>" + this.item.getDetail() + "</p>");
        }
        if (res.length() > 0) {
            res.append("<br/>");
        }
        if (this.item.getDocumentation() != null && (this.item.getDocumentation().isLeft() && this.item.getDocumentation().getLeft() != null && !((String)this.item.getDocumentation().getLeft()).isEmpty() || this.item.getDocumentation().isRight() && this.item.getDocumentation().getRight() != null && ((MarkupContent)this.item.getDocumentation().getRight()).getValue() != null && !((MarkupContent)this.item.getDocumentation().getRight()).getValue().isEmpty()) && (htmlDocString = LSPEclipseUtils.getHtmlDocString((Either<String, MarkupContent>)this.item.getDocumentation())) != null) {
            res.append(htmlDocString);
        }
        return res.toString();
    }

    private void updateCompletionItem(CompletionItem resolvedItem) {
        if (resolvedItem == null) {
            return;
        }
        if (resolvedItem.getLabel() != null) {
            this.item.setLabel(resolvedItem.getLabel());
        }
        if (resolvedItem.getKind() != null) {
            this.item.setKind(resolvedItem.getKind());
        }
        if (resolvedItem.getDetail() != null) {
            this.item.setDetail(resolvedItem.getDetail());
        }
        if (resolvedItem.getDocumentation() != null) {
            this.item.setDocumentation(resolvedItem.getDocumentation());
        }
        if (resolvedItem.getInsertText() != null) {
            this.item.setInsertText(resolvedItem.getInsertText());
        }
        if (resolvedItem.getInsertTextFormat() != null) {
            this.item.setInsertTextFormat(resolvedItem.getInsertTextFormat());
        }
        if (resolvedItem.getTextEdit() != null) {
            this.item.setTextEdit(resolvedItem.getTextEdit());
        }
        if (resolvedItem.getAdditionalTextEdits() != null) {
            this.item.setAdditionalTextEdits(resolvedItem.getAdditionalTextEdits());
        }
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.item.getInsertText().substring(completionOffset - this.bestOffset);
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        Either textEdit = this.item.getTextEdit();
        if (textEdit != null) {
            if (textEdit.isLeft()) {
                try {
                    return LSPEclipseUtils.toOffset(((TextEdit)textEdit.getLeft()).getRange().getStart(), document);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            } else {
                try {
                    return LSPEclipseUtils.toOffset(((InsertReplaceEdit)textEdit.getRight()).getInsert().getStart(), document);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        String insertText = this.getInsertText();
        try {
            String subDoc = document.get(Math.max(0, completionOffset - insertText.length()), Math.min(insertText.length(), completionOffset));
            int i = 0;
            while (i < insertText.length() && i < completionOffset) {
                String tentativeCommonString = subDoc.substring(i);
                if (insertText.startsWith(tentativeCommonString)) {
                    return completionOffset - tentativeCommonString.length();
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return completionOffset;
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0, this.bestOffset);
    }

    /*
     * Unable to fully structure code
     */
    protected void apply(IDocument document, char trigger, int stateMask, int offset) {
        insertText = null;
        eitherTextEdit = this.item.getTextEdit();
        textEdit = null;
        if (eitherTextEdit != null) {
            if (eitherTextEdit.isLeft()) {
                textEdit = (TextEdit)eitherTextEdit.getLeft();
            } else {
                insertReplaceEdit = (InsertReplaceEdit)eitherTextEdit.getRight();
                textEdit = new TextEdit(insertReplaceEdit.getInsert(), insertReplaceEdit.getNewText());
            }
        }
        try {
            if (textEdit == null) {
                insertText = this.getInsertText();
                start = LSPEclipseUtils.toPosition(this.bestOffset, document);
                end = LSPEclipseUtils.toPosition(offset, document);
                textEdit = new TextEdit(new Range(start, end), insertText);
            } else if (offset > this.initialOffset) {
                shift = offset - this.initialOffset;
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + shift);
            }
            start = textEdit.getRange().getStart();
            end = textEdit.getRange().getEnd();
            if (start.getLine() > end.getLine() || start.getLine() == end.getLine() && start.getCharacter() > end.getCharacter()) {
                textEdit.getRange().setEnd(start);
                textEdit.getRange().setStart(end);
            }
            documentEnd = LSPEclipseUtils.toPosition(document.getLength(), document);
            textEditEnd = textEdit.getRange().getEnd();
            if (documentEnd.getLine() < textEditEnd.getLine() || documentEnd.getLine() == textEditEnd.getLine() && documentEnd.getCharacter() < textEditEnd.getCharacter()) {
                textEdit.getRange().setEnd(documentEnd);
            }
            if (insertText != null) {
                shift = offset - this.bestOffset;
                commonSize = 0;
                while (commonSize < insertText.length() - shift && document.getLength() > offset + commonSize && document.getChar(this.bestOffset + shift + commonSize) == insertText.charAt(commonSize + shift)) {
                    ++commonSize;
                }
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + commonSize);
            }
            insertText = textEdit.getNewText();
            regions = new LinkedHashMap<String, List>();
            insertionOffset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
            insertionOffset = this.computeNewOffset(this.item.getAdditionalTextEdits(), insertionOffset, document);
            if (this.item.getInsertTextFormat() == InsertTextFormat.Snippet) {
                currentSnippetOffsetInInsertText = 0;
                while ((currentSnippetOffsetInInsertText = insertText.indexOf(36, currentSnippetOffsetInInsertText)) != -1) {
                    keyBuilder = new StringBuilder();
                    isChoice = false;
                    snippetProposals = new ArrayList<String>();
                    offsetInSnippet = 1;
                    while (currentSnippetOffsetInInsertText + offsetInSnippet < insertText.length() && Character.isDigit(insertText.charAt(currentSnippetOffsetInInsertText + offsetInSnippet))) {
                        keyBuilder.append(insertText.charAt(currentSnippetOffsetInInsertText + offsetInSnippet));
                        ++offsetInSnippet;
                    }
                    if (keyBuilder.length() == 0 && insertText.substring(currentSnippetOffsetInInsertText).startsWith("${")) {
                        offsetInSnippet = 2;
                        while (currentSnippetOffsetInInsertText + offsetInSnippet < insertText.length() && Character.isDigit(insertText.charAt(currentSnippetOffsetInInsertText + offsetInSnippet))) {
                            keyBuilder.append(insertText.charAt(currentSnippetOffsetInInsertText + offsetInSnippet));
                            ++offsetInSnippet;
                        }
                        if (currentSnippetOffsetInInsertText + offsetInSnippet < insertText.length() && ((currentChar = insertText.charAt(currentSnippetOffsetInInsertText + offsetInSnippet)) == ':' || currentChar == '|')) {
                            isChoice |= currentChar == '|';
                            ++offsetInSnippet;
                        }
                        close = false;
                        valueBuilder = new StringBuilder();
                        while (currentSnippetOffsetInInsertText + offsetInSnippet < insertText.length() && !close) {
                            currentChar = insertText.charAt(currentSnippetOffsetInInsertText + offsetInSnippet);
                            if (valueBuilder.length() > 0 && (isChoice && (currentChar == ',' || currentChar == '|') || currentChar == '}')) {
                                value = valueBuilder.toString();
                                if (value.startsWith("$") && (varValue = this.getVariableValue(value.substring(1))) != null) {
                                    value = varValue;
                                }
                                snippetProposals.add(value);
                                valueBuilder = new StringBuilder();
                            } else if (currentChar != '}') {
                                valueBuilder.append(currentChar);
                            }
                            close = currentChar == '}';
                            ++offsetInSnippet;
                        }
                    }
                    v0 = defaultProposal = snippetProposals.isEmpty() != false ? "" : (String)snippetProposals.get(0);
                    if (keyBuilder.length() > 0) {
                        key = keyBuilder.toString();
                        insertText = String.valueOf(insertText.substring(0, currentSnippetOffsetInInsertText)) + defaultProposal + insertText.substring(currentSnippetOffsetInInsertText + offsetInSnippet);
                        position = null;
                        if (!snippetProposals.isEmpty()) {
                            replacementOffset = insertionOffset + currentSnippetOffsetInInsertText;
                            proposals = (ICompletionProposal[])snippetProposals.stream().map((Function<String, CompletionProposal>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$2(int java.lang.String java.lang.String ), (Ljava/lang/String;)Lorg/eclipse/jface/text/contentassist/CompletionProposal;)((int)replacementOffset, (String)defaultProposal)).toArray((IntFunction<ICompletionProposal[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$3(int ), (I)[Lorg/eclipse/jface/text/contentassist/ICompletionProposal;)());
                            position = new ProposalPosition(document, insertionOffset + currentSnippetOffsetInInsertText, defaultProposal.length(), proposals);
                        } else {
                            position = new LinkedPosition(document, insertionOffset + currentSnippetOffsetInInsertText, defaultProposal.length());
                        }
                        if (this.firstPosition == null) {
                            this.firstPosition = position;
                        }
                        regions.computeIfAbsent(key, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(position);
                        currentSnippetOffsetInInsertText += defaultProposal.length();
                        continue;
                    }
                    ++currentSnippetOffsetInInsertText;
                }
            }
            textEdit.setNewText(insertText);
            additionalEdits = this.item.getAdditionalTextEdits();
            if (additionalEdits != null && !additionalEdits.isEmpty()) {
                allEdits = new ArrayList<TextEdit>();
                allEdits.add(textEdit);
                allEdits.addAll(additionalEdits);
                LSPEclipseUtils.applyEdits(document, allEdits);
            } else {
                LSPEclipseUtils.applyEdit(textEdit, document);
            }
            if (regions.size() != 1 || ((List)regions.values().iterator().next()).size() != 1) ** GOTO lbl-1000
            if (((List)regions.values().iterator().next()).stream().noneMatch((Predicate<LinkedPosition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/eclipse/jface/text/link/LinkedPosition;)Z)(ProposalPosition.class))) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = onlyPlaceCaret = false;
            }
            if (this.viewer != null && !regions.isEmpty() && !onlyPlaceCaret) {
                model = new LinkedModeModel();
                for (List positions : regions.values()) {
                    group = new LinkedPositionGroup();
                    for (LinkedPosition position : positions) {
                        group.addPosition(position);
                    }
                    model.addGroup(group);
                }
                model.forceInstall();
                ui = new EditorLinkedModeUI(model, this.viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            } else if (onlyPlaceCaret) {
                region = (Position)((List)regions.values().iterator().next()).get(0);
                this.selection = new Region(region.getOffset(), region.getLength());
            } else {
                this.selection = new Region(insertionOffset + textEdit.getNewText().length(), 0);
            }
            if (this.item.getCommand() != null) {
                LanguageServiceAccessor.resolveServerDefinition(this.languageServer).map((Function<LanguageServersRegistry.LanguageServerDefinition, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$6(org.eclipse.lsp4e.LanguageServersRegistry$LanguageServerDefinition ), (Lorg/eclipse/lsp4e/LanguageServersRegistry$LanguageServerDefinition;)Ljava/lang/String;)()).ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$7(org.eclipse.jface.text.IDocument java.lang.String ), (Ljava/lang/String;)V)((LSIncompleteCompletionProposal)this, (IDocument)document));
            }
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    private int computeNewOffset(List<TextEdit> additionalTextEdits, int insertionOffset, IDocument doc) {
        if (additionalTextEdits != null && !additionalTextEdits.isEmpty()) {
            int adjustment = 0;
            for (TextEdit edit : additionalTextEdits) {
                try {
                    Range rng = edit.getRange();
                    int start = LSPEclipseUtils.toOffset(rng.getStart(), doc);
                    if (start > insertionOffset) continue;
                    int end = LSPEclipseUtils.toOffset(rng.getEnd(), doc);
                    int orgLen = end - start;
                    int newLeng = edit.getNewText().length();
                    int editChange = newLeng - orgLen;
                    adjustment += editChange;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
            return insertionOffset + adjustment;
        }
        return insertionOffset;
    }

    private String getVariableValue(String variableName) {
        switch (variableName) {
            case "TM_FILENAME_BASE": {
                IPath pathBase = LSPEclipseUtils.toPath(this.document).removeFileExtension();
                String fileName = pathBase.lastSegment();
                return fileName != null ? fileName : "";
            }
            case "TM_FILENAME": {
                return LSPEclipseUtils.toPath(this.document).lastSegment();
            }
            case "TM_FILEPATH": {
                return this.getAbsoluteLocation(LSPEclipseUtils.toPath(this.document));
            }
            case "TM_DIRECTORY": {
                IPath dirPath = LSPEclipseUtils.toPath(this.document).removeLastSegments(1);
                return this.getAbsoluteLocation(dirPath);
            }
            case "TM_LINE_INDEX": {
                int lineIndex = this.getTextEditRange().getStart().getLine();
                return Integer.toString(lineIndex);
            }
            case "TM_LINE_NUMBER": {
                int lineNumber = this.getTextEditRange().getStart().getLine();
                return Integer.toString(lineNumber + 1);
            }
            case "TM_CURRENT_LINE": {
                int currentLineIndex = this.getTextEditRange().getStart().getLine();
                try {
                    IRegion lineInformation = this.document.getLineInformation(currentLineIndex);
                    String line = this.document.get(lineInformation.getOffset(), lineInformation.getLength());
                    return line;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    return "";
                }
            }
            case "TM_SELECTED_TEXT": {
                Range selectedRange = this.getTextEditRange();
                try {
                    int startOffset = LSPEclipseUtils.toOffset(selectedRange.getStart(), this.document);
                    int endOffset = LSPEclipseUtils.toOffset(selectedRange.getEnd(), this.document);
                    String selectedText = this.document.get(startOffset, endOffset - startOffset);
                    return selectedText;
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logWarning(e.getMessage(), e);
                    return "";
                }
            }
            case "TM_CURRENT_WORD": {
                return "";
            }
        }
        return null;
    }

    private Range getTextEditRange() {
        if (this.item.getTextEdit().isLeft()) {
            return ((TextEdit)this.item.getTextEdit().getLeft()).getRange();
        }
        return ((InsertReplaceEdit)this.item.getTextEdit().getRight()).getInsert();
    }

    private String getAbsoluteLocation(IPath path) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res != null) {
            IPath location;
            IPath iPath = location = res.getType() == 4 ? res.getLocation() : res.getRawLocation();
            if (location != null) {
                return location.toOSString();
            }
        }
        return path.toFile().getAbsolutePath();
    }

    protected String getInsertText() {
        String insertText = this.item.getInsertText();
        Either eitherTextEdit = this.item.getTextEdit();
        if (eitherTextEdit != null) {
            insertText = eitherTextEdit.isLeft() ? ((TextEdit)eitherTextEdit.getLeft()).getNewText() : ((InsertReplaceEdit)eitherTextEdit.getRight()).getNewText();
        }
        if (insertText == null) {
            insertText = this.item.getLabel();
        }
        return insertText;
    }

    public Point getSelection(IDocument document) {
        if (this.firstPosition != null) {
            return new Point(this.firstPosition.getOffset(), this.firstPosition.getLength());
        }
        if (this.selection == null) {
            return null;
        }
        return new Point(this.selection.getOffset(), this.selection.getLength());
    }

    public String getAdditionalProposalInfo() {
        return this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
    }

    public Image getImage() {
        return LSPImages.imageFromCompletionItem(this.item);
    }

    public IContextInformation getContextInformation() {
        return this;
    }

    public String getContextDisplayString() {
        return this.getAdditionalProposalInfo();
    }

    public String getInformationDisplayString() {
        return this.getAdditionalProposalInfo();
    }

    public String getSortText() {
        if (this.item.getSortText() != null && !this.item.getSortText().isEmpty()) {
            return this.item.getSortText();
        }
        return this.item.getLabel();
    }

    public String getFilterString() {
        if (this.item.getFilterText() != null && !this.item.getFilterText().isEmpty()) {
            return this.item.getFilterText();
        }
        return this.item.getLabel();
    }

    private static /* synthetic */ CompletionProposal lambda$2(int n, String string, String string2) {
        return new CompletionProposal(string2, n, string.length(), n + string2.length());
    }

    private static /* synthetic */ ICompletionProposal[] lambda$3(int n) {
        return new ICompletionProposal[n];
    }

    private static /* synthetic */ List lambda$4(String whatever) {
        return new ArrayList();
    }

    private static /* synthetic */ String lambda$6(LanguageServersRegistry.LanguageServerDefinition definition) {
        return definition.id;
    }

    private /* synthetic */ void lambda$7(IDocument iDocument, String id) {
        CompletableFuture<Object> completableFuture = CommandExecutor.executeCommand(this.item.getCommand(), iDocument, id);
    }
}

