/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchHistorySelectionDialog;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;

class ShowSearchHistoryDialogAction
extends Action {
    private SearchView fSearchView;

    public ShowSearchHistoryDialogAction(SearchView searchView) {
        super(SearchMessages.ShowSearchesAction_label);
        this.setToolTipText(SearchMessages.ShowSearchesAction_tooltip);
        this.fSearchView = searchView;
    }

    public void run() {
        Object[] result;
        ISearchQuery[] queries = NewSearchUI.getQueries();
        ArrayList<ISearchResult> input = new ArrayList<ISearchResult>();
        ISearchQuery[] iSearchQueryArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchQuery query = iSearchQueryArray[n2];
            ISearchResult search = query.getSearchResult();
            input.add(search);
            ++n2;
        }
        SearchHistorySelectionDialog dlg = new SearchHistorySelectionDialog(SearchPlugin.getActiveWorkbenchShell(), input);
        ISearchResult current = this.fSearchView.getCurrentSearchResult();
        if (current != null) {
            Object[] selected = new Object[]{current};
            dlg.setInitialSelections(selected);
        }
        if (dlg.open() == 0 && (result = dlg.getResult()) != null && result.length == 1) {
            ISearchResult searchResult = (ISearchResult)result[0];
            InternalSearchUI.getInstance().showSearchResult(this.fSearchView, searchResult, dlg.isOpenInNewView());
        }
    }
}

