/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.model.AbstractModelLines;
import org.eclipse.tm4e.core.model.IModelTokensChangedListener;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.core.model.TMTokenization;
import org.eclipse.tm4e.core.model.TokenizationResult;

public class TMModel
implements ITMModel {
    private static final System.Logger LOGGER = System.getLogger(TMModel.class.getName());
    private @Nullable IGrammar grammar;
    private final Set<IModelTokensChangedListener> listeners = new CopyOnWriteArraySet<IModelTokensChangedListener>();
    private @Nullable TMTokenization tokenizer;
    private volatile @Nullable TokenizerThread fThread;
    private final AbstractModelLines modelLines;
    private final PriorityBlockingQueue<Integer> invalidLines = new PriorityBlockingQueue();

    public TMModel(AbstractModelLines lines) {
        this.modelLines = lines;
        this.modelLines.setModel(this);
        this.invalidateLine(0);
    }

    private UpdateTokensOfLineResult updateTokensOfLine(ModelTokensChangedEventBuilder eventBuilder, int lineIndex, Duration timeLimit) {
        TokenizationResult r;
        AbstractModelLines.ModelLine modelLine = this.modelLines.getOrNull(lineIndex);
        if (modelLine == null) {
            return UpdateTokensOfLineResult.DONE;
        }
        try {
            String lineText = this.modelLines.getLineText(lineIndex);
            r = NullSafetyHelper.castNonNull(this.tokenizer).tokenize(lineText, modelLine.startState, 0, timeLimit);
        }
        catch (Exception ex) {
            LOGGER.log(System.Logger.Level.ERROR, ex.toString());
            return UpdateTokensOfLineResult.UPDATE_FAILED;
        }
        if (r.stoppedEarly) {
            r.tokens.add(new TMToken(r.actualStopOffset, ""));
            r.endState = modelLine.startState;
        }
        modelLine.tokens = r.tokens;
        eventBuilder.registerChangedTokens(lineIndex + 1);
        modelLine.isInvalid = false;
        AbstractModelLines.ModelLine nextModelLine = this.modelLines.getOrNull(lineIndex + 1);
        if (nextModelLine == null) {
            return UpdateTokensOfLineResult.DONE;
        }
        if (!nextModelLine.isInvalid && nextModelLine.startState.equals(r.endState)) {
            return UpdateTokensOfLineResult.DONE;
        }
        nextModelLine.startState = r.endState;
        return UpdateTokensOfLineResult.NEXT_LINE_IS_OUTDATED;
    }

    @Override
    public @Nullable IGrammar getGrammar() {
        return this.grammar;
    }

    @Override
    public void setGrammar(IGrammar grammar) {
        if (!Objects.equals(grammar, this.grammar)) {
            this.grammar = grammar;
            TMTokenization tokenizer = this.tokenizer = new TMTokenization(grammar);
            this.modelLines.get((int)0).startState = tokenizer.getInitialState();
            this.startTokenizerThread();
        }
    }

    @Override
    public synchronized void addModelTokensChangedListener(IModelTokensChangedListener listener) {
        this.listeners.add(listener);
        this.startTokenizerThread();
    }

    @Override
    public synchronized void removeModelTokensChangedListener(IModelTokensChangedListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.stopTokenizerThread();
        }
    }

    @Override
    public void dispose() {
        this.stopTokenizerThread();
        this.modelLines.dispose();
    }

    private synchronized void startTokenizerThread() {
        if (this.tokenizer != null && !this.listeners.isEmpty()) {
            TokenizerThread fThread = this.fThread;
            if (fThread == null || fThread.isInterrupted()) {
                fThread = this.fThread = new TokenizerThread(this.getClass().getName());
            }
            if (!fThread.isAlive()) {
                fThread.start();
            }
        }
    }

    private synchronized void stopTokenizerThread() {
        TokenizerThread fThread = this.fThread;
        if (fThread == null) {
            return;
        }
        fThread.interrupt();
        this.fThread = null;
    }

    private void buildAndEmitEvent(Consumer<ModelTokensChangedEventBuilder> callback) {
        ModelTokensChangedEventBuilder eventBuilder = new ModelTokensChangedEventBuilder(this);
        callback.accept(eventBuilder);
        ModelTokensChangedEvent event = eventBuilder.build();
        if (event != null) {
            this.emit(event);
        }
    }

    private void emit(ModelTokensChangedEvent e) {
        for (IModelTokensChangedListener listener : this.listeners) {
            listener.modelTokensChanged(e);
        }
    }

    @Override
    public @Nullable List<TMToken> getLineTokens(int lineIndex) {
        AbstractModelLines.ModelLine modelLine = this.modelLines.getOrNull(lineIndex);
        return modelLine == null ? null : modelLine.tokens;
    }

    public int getNumberOfLines() {
        return this.modelLines.getNumberOfLines();
    }

    void invalidateLine(int lineIndex) {
        AbstractModelLines.ModelLine modelLine = this.modelLines.getOrNull(lineIndex);
        if (modelLine != null) {
            modelLine.isInvalid = true;
            this.invalidLines.add(lineIndex);
        }
    }

    public String toString() {
        return StringUtils.toString(this, sb -> {
            StringBuilder stringBuilder = sb.append("grammar=").append(this.grammar);
        });
    }

    private static final class ModelTokensChangedEventBuilder {
        final ITMModel model;
        final List<Range> ranges = new ArrayList<Range>();

        ModelTokensChangedEventBuilder(ITMModel model) {
            this.model = model;
        }

        void registerChangedTokens(int lineNumber) {
            Range previousRange = MoreCollections.findLastElement(this.ranges);
            if (previousRange != null && previousRange.toLineNumber == lineNumber - 1) {
                ++previousRange.toLineNumber;
            } else {
                this.ranges.add(new Range(lineNumber));
            }
        }

        @Nullable ModelTokensChangedEvent build() {
            if (this.ranges.isEmpty()) {
                return null;
            }
            return new ModelTokensChangedEvent(this.ranges, this.model);
        }
    }

    private final class TokenizerThread
    extends Thread {
        private final int MAX_LOOP_TIME = 200;
        private final Duration MAX_TIME_PER_LINE;

        TokenizerThread(String name) {
            super(name);
            this.MAX_LOOP_TIME = 200;
            this.MAX_TIME_PER_LINE = Duration.ofSeconds(1L);
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && TMModel.this.fThread == this) {
                try {
                    int lineIndexToProcess = TMModel.this.invalidLines.take();
                    AbstractModelLines.ModelLine modelLine = TMModel.this.modelLines.getOrNull(lineIndexToProcess);
                    if (modelLine == null || !modelLine.isInvalid) continue;
                    try {
                        this.revalidateTokens(lineIndexToProcess);
                    }
                    catch (Exception ex) {
                        LOGGER.log(System.Logger.Level.ERROR, ex.getMessage(), (Throwable)ex);
                        TMModel.this.invalidateLine(lineIndexToProcess);
                    }
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }

        private void revalidateTokens(int startLineIndex) {
            TMModel.this.buildAndEmitEvent(eventBuilder -> {
                int lineIndex = startLineIndex;
                long startTime = System.currentTimeMillis();
                while (lineIndex < TMModel.this.modelLines.getNumberOfLines()) {
                    switch (TMModel.this.updateTokensOfLine((ModelTokensChangedEventBuilder)eventBuilder, lineIndex, this.MAX_TIME_PER_LINE)) {
                        case DONE: {
                            return;
                        }
                        case UPDATE_FAILED: {
                            TMModel.this.invalidateLine(lineIndex);
                            return;
                        }
                        case NEXT_LINE_IS_OUTDATED: {
                            if (System.currentTimeMillis() - startTime >= 200L) {
                                TMModel.this.invalidateLine(lineIndex + 1);
                                return;
                            }
                            ++lineIndex;
                        }
                    }
                }
            });
        }
    }

    private static enum UpdateTokensOfLineResult {
        DONE,
        UPDATE_FAILED,
        NEXT_LINE_IS_OUTDATED;

    }
}

