/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.ISystemTypedObject;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;

public class SystemDeleteTableRow {
    private Object element;
    private String name;
    private String type;
    private ImageDescriptor imageDescriptor;
    private ISystemViewElementAdapter adapter;
    private ISystemRemoteElementAdapter remoteAdapter;
    private int rowNbr = 0;

    public SystemDeleteTableRow(Object element, int rowNbr) {
        if (element instanceof SystemSimpleContentElement) {
            element = ((SystemSimpleContentElement)element).getData();
        }
        this.element = element;
        this.adapter = this.getViewAdapter(element);
        this.remoteAdapter = this.getRemoteAdapter(element);
        this.rowNbr = rowNbr;
        if (this.adapter != null) {
            this.name = this.adapter.getName(element);
        } else if (element instanceof ISystemTypedObject) {
            this.name = ((ISystemTypedObject)element).getName();
        } else if (element instanceof IResource) {
            this.name = ((IResource)element).getName();
        }
        ISystemViewElementAdapter typeAdapter = this.adapter;
        Object typeElement = element;
        if (typeElement instanceof ISystemFilterPoolReference) {
            typeElement = ((ISystemFilterPoolReference)typeElement).getReferencedFilterPool();
            typeAdapter = this.getViewAdapter(typeElement);
        }
        this.type = typeAdapter != null ? typeAdapter.getType(typeElement) : (element instanceof ISystemTypedObject ? ((ISystemTypedObject)element).getType() : (element instanceof IResource ? (element instanceof IFolder || element instanceof IProject ? SystemViewResources.RESID_PROPERTY_FILE_TYPE_FOLDER_VALUE : SystemViewResources.RESID_PROPERTY_FILE_TYPE_FILE_VALUE) : element.getClass().getName()));
        if (this.adapter != null) {
            this.imageDescriptor = this.adapter.getImageDescriptor(element);
        } else if (element instanceof ISystemTypedObject) {
            this.imageDescriptor = ((ISystemTypedObject)element).getImageDescriptor();
        } else if (element instanceof IFolder) {
            this.imageDescriptor = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfolderIcon");
        } else if (element instanceof IFile) {
            this.imageDescriptor = RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry().getImageDescriptor(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getRowNumber() {
        return this.rowNbr;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public Object getElement() {
        return this.element;
    }

    public ISystemViewElementAdapter getViewAdapter() {
        return this.adapter;
    }

    public ISystemRemoteElementAdapter getRemoteAdapter() {
        return this.remoteAdapter;
    }

    public boolean isRemote() {
        return this.remoteAdapter != null;
    }

    protected ISystemViewElementAdapter getViewAdapter(Object o) {
        return SystemAdapterHelpers.getViewAdapter(o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    public String toString() {
        return this.name;
    }
}

