/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.processes.ui;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.processes.ui.ProcessesPlugin;
import org.eclipse.rse.internal.processes.ui.SystemProcessesResources;
import org.eclipse.rse.internal.processes.ui.view.SystemProcessStatesContentProvider;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemTestFilterStringAction;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.ISystemProcessRemoteConstants;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystemConfiguration;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ValidatorIntegerRangeInput;
import org.eclipse.rse.ui.validators.ValidatorLongRangeInput;
import org.eclipse.rse.ui.validators.ValidatorSpecialChar;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemProcessFilterStringEditPane
extends SystemFilterStringEditPane {
    protected Label lblStatus;
    protected CheckboxTableViewer chkStatus;
    protected Label lblExeName;
    protected Label lblUserName;
    protected Label lblGid;
    protected Text txtExeName;
    protected Text txtUserName;
    protected Text txtGid;
    protected Label lblMinVM;
    protected Label lblMaxVM;
    protected Text txtMinVM;
    protected Text txtMaxVM;
    protected Button chkBoxUnlimitedVM;
    protected int gidLimit = Integer.MAX_VALUE;
    protected long vmMaxValue = Long.MAX_VALUE;
    protected int exeNameLength = 256;
    protected int userNameLength = 256;
    protected ValidatorLongRangeInput vmRangeValidator = new ValidatorLongRangeInput(0L, this.vmMaxValue);
    protected ValidatorIntegerRangeInput gidValidator = new ValidatorIntegerRangeInput(0, this.gidLimit);
    protected ValidatorSpecialChar nameValidator = new ValidatorSpecialChar(" \t|", true);
    protected String[] inputFilterStrings;
    protected boolean noValidation = false;
    protected boolean callerInstanceOfWizardPage;
    protected boolean callerInstanceOfSystemPromptDialog;
    protected boolean skipUniquenessChecking;
    protected boolean calledFromVerify;
    protected boolean dontStealFocus;
    protected IRemoteProcessSubSystemConfiguration inputSubsystemConfiguration = null;
    protected static final int SIZING_SELECTION_WIDGET_HEIGHT = 90;
    protected static final int SIZING_SELECTION_WIDGET_WIDTH = 145;

    public SystemProcessFilterStringEditPane(Shell shell) {
        super(shell);
        this.gidValidator.setBlankAllowed(true);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.enable((Control)this.lblStatus, editable);
        this.enable((Control)this.lblExeName, editable);
        this.enable((Control)this.lblUserName, editable);
        this.enable((Control)this.lblGid, editable);
        this.enable((Control)this.txtExeName, editable);
        this.enable((Control)this.txtUserName, editable);
        this.enable((Control)this.txtGid, editable);
        this.enable((Control)this.lblMinVM, editable);
        this.enable((Control)this.lblMaxVM, editable);
        this.enable((Control)this.txtMinVM, editable);
        this.enable((Control)this.txtMaxVM, editable);
        this.enable((Control)this.chkBoxUnlimitedVM, editable);
    }

    public void setExeNameLength(int max) {
        this.exeNameLength = max;
        if (this.txtExeName != null) {
            this.txtExeName.setTextLimit(max);
        }
    }

    public void setUserNameLength(int max) {
        this.userNameLength = max;
        if (this.txtUserName != null) {
            this.txtUserName.setTextLimit(max);
        }
    }

    public void setExistingStrings(String[] existingStrings) {
        this.inputFilterStrings = existingStrings;
    }

    public Control createContents(Composite parent) {
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)1);
        int gridColumns = 2;
        Composite sub_prompts1 = SystemWidgetHelpers.createComposite((Composite)composite_prompts, (int)gridColumns);
        this.lblExeName = SystemWidgetHelpers.createLabel((Composite)sub_prompts1, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_EXENAME_LABEL);
        this.lblExeName.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_EXENAME_TOOLTIP);
        this.txtExeName = SystemWidgetHelpers.createTextField((Composite)sub_prompts1, null);
        this.txtExeName.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_EXENAME_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.txtExeName, (String)"org.eclipse.rse.processes.ui.pfsd0001");
        this.updateGridData((Control)this.txtExeName, gridColumns - 1);
        this.txtExeName.setText("*");
        this.lblUserName = SystemWidgetHelpers.createLabel((Composite)sub_prompts1, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_USERNAME_LABEL);
        this.lblUserName.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_USERNAME_TOOLTIP);
        this.txtUserName = SystemWidgetHelpers.createTextField((Composite)sub_prompts1, null);
        this.txtUserName.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_USERNAME_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.txtUserName, (String)"org.eclipse.rse.processes.ui.pfsd0002");
        this.updateGridData((Control)this.txtUserName, gridColumns - 1);
        this.txtUserName.setText("*");
        this.lblGid = SystemWidgetHelpers.createLabel((Composite)sub_prompts1, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_GID_LABEL);
        this.lblGid.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_GID_TOOLTIP);
        this.txtGid = SystemWidgetHelpers.createTextField((Composite)sub_prompts1, null);
        this.txtGid.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_GID_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.txtGid, (String)"org.eclipse.rse.processes.ui.pfsd0003");
        this.updateGridData((Control)this.txtGid, gridColumns - 1);
        this.txtGid.setText("*");
        this.lblStatus = SystemWidgetHelpers.createLabel((Composite)sub_prompts1, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_STATUS_LABEL);
        this.lblStatus.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_STATUS_TOOLTIP);
        this.chkStatus = CheckboxTableViewer.newCheckList((Composite)sub_prompts1, (int)2048);
        GridData data = new GridData(34);
        data.heightHint = 90;
        data.widthHint = 145;
        this.chkStatus.getTable().setLayoutData((Object)data);
        this.chkStatus.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        SystemWidgetHelpers.setHelp((Control)this.chkStatus.getControl(), (String)"org.eclipse.rse.processes.ui.pfsd0004");
        SystemWidgetHelpers.createLabel((Composite)sub_prompts1, (String)"      ");
        this.addSelectionButtons(sub_prompts1);
        Composite subsub = SystemWidgetHelpers.createComposite((Composite)sub_prompts1, (int)gridColumns, (int)3, (boolean)false, null, (int)-1, (int)-1);
        this.lblMinVM = SystemWidgetHelpers.createLabel((Composite)subsub, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_MINVM_LABEL);
        this.lblMinVM.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_MINVM_TOOLTIP);
        this.txtMinVM = SystemWidgetHelpers.createTextField((Composite)subsub, null);
        this.txtMinVM.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_MINVM_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.txtMinVM, (String)"org.eclipse.rse.processes.ui.pfsd0005");
        this.txtMinVM.setText("0");
        SystemWidgetHelpers.createLabel((Composite)subsub, (String)"      ");
        this.lblMaxVM = SystemWidgetHelpers.createLabel((Composite)subsub, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_MAXVM_LABEL);
        this.lblMaxVM.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_MAXVM_TOOLTIP);
        this.txtMaxVM = SystemWidgetHelpers.createTextField((Composite)subsub, null);
        this.txtMaxVM.setToolTipText(SystemProcessesResources.RESID_PROCESSFILTERSTRING_MAXVM_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.txtMaxVM, (String)"org.eclipse.rse.processes.ui.pfsd0006");
        this.txtMaxVM.setEnabled(false);
        this.chkBoxUnlimitedVM = SystemWidgetHelpers.createCheckBox((Composite)subsub, (int)1, null, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_UNLIMITED_LABEL, (String)SystemProcessesResources.RESID_PROCESSFILTERSTRING_UNLIMITED_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.chkBoxUnlimitedVM, (String)"org.eclipse.rse.processes.ui.pfsd0007");
        this.txtExeName.setFocus();
        if (this.refProvider != null) {
            this.inputSubsystemConfiguration = (IRemoteProcessSubSystemConfiguration)((ISubSystem)this.refProvider).getSubSystemConfiguration();
        } else if (this.provider != null) {
            this.inputSubsystemConfiguration = (IRemoteProcessSubSystemConfiguration)this.provider;
        }
        SystemProcessStatesContentProvider p = new SystemProcessStatesContentProvider();
        this.chkStatus.setContentProvider((IContentProvider)p);
        this.chkStatus.setInput((Object)p.getElements(null));
        this.txtExeName.setTextLimit(this.exeNameLength);
        this.txtUserName.setTextLimit(this.userNameLength);
        this.resetFields();
        this.doInitializeFields();
        this.txtExeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemProcessFilterStringEditPane.this.validateNameInput(SystemProcessFilterStringEditPane.this.txtExeName);
            }
        });
        this.txtUserName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemProcessFilterStringEditPane.this.validateNameInput(SystemProcessFilterStringEditPane.this.txtUserName);
            }
        });
        this.txtGid.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemProcessFilterStringEditPane.this.validateGidInput();
            }
        });
        this.txtMinVM.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SystemProcessFilterStringEditPane.this.validateMinVMInput() == null && !SystemProcessFilterStringEditPane.this.chkBoxUnlimitedVM.getSelection() && !SystemProcessFilterStringEditPane.this.txtMaxVM.getText().trim().equals("")) {
                    SystemMessage message = SystemProcessFilterStringEditPane.this.validateMinLessThanMax();
                    SystemProcessFilterStringEditPane.this.fireChangeEvent(message);
                }
            }
        });
        this.txtMaxVM.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SystemProcessFilterStringEditPane.this.validateMaxVMInput() == null && !SystemProcessFilterStringEditPane.this.txtMinVM.getText().trim().equals("")) {
                    SystemMessage message = SystemProcessFilterStringEditPane.this.validateMinLessThanMax();
                    SystemProcessFilterStringEditPane.this.fireChangeEvent(message);
                }
            }
        });
        this.chkBoxUnlimitedVM.addSelectionListener((SelectionListener)this);
        this.setEditable(this.editable);
        return composite_prompts;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, null, (String)SystemResources.RESID_SELECTFILES_SELECTALL_BUTTON_ROOT_LABEL, (String)SystemResources.RESID_SELECTFILES_SELECTALL_BUTTON_ROOT_TOOLTIP);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemProcessFilterStringEditPane.this.chkStatus.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, null, (String)SystemResources.RESID_SELECTFILES_DESELECTALL_BUTTON_ROOT_LABEL, (String)SystemResources.RESID_SELECTFILES_DESELECTALL_BUTTON_ROOT_TOOLTIP);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemProcessFilterStringEditPane.this.chkStatus.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void updateGridData(Control widget, int gridColumns) {
        GridData data = (GridData)widget.getLayoutData();
        data.horizontalSpan = gridColumns;
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 32;
    }

    public Control getInitialFocusControl() {
        return this.txtExeName;
    }

    protected void doInitializeFields() {
        if (this.txtExeName == null) {
            return;
        }
        if (this.inputFilterString != null) {
            HostProcessFilterImpl rffs = new HostProcessFilterImpl(this.inputFilterString);
            String defaultExeName = rffs.getName();
            this.txtExeName.setText(defaultExeName == null ? "" : defaultExeName);
            String defaultUserName = rffs.getUsername();
            this.txtUserName.setText(defaultUserName == null ? "" : defaultUserName);
            String defaultGid = rffs.getGid();
            this.txtGid.setText(defaultGid == null ? "" : defaultGid);
            String defaultMinVM = rffs.getMinVM();
            this.txtMinVM.setText(defaultMinVM == null ? "" : defaultMinVM);
            String defaultMaxVM = rffs.getMaxVM();
            if (defaultMaxVM.equals("-1")) {
                this.txtMaxVM.setText("");
                this.txtMaxVM.setEnabled(false);
                this.chkBoxUnlimitedVM.setEnabled(true);
                this.chkBoxUnlimitedVM.setSelection(true);
            } else {
                this.txtMaxVM.setEnabled(true);
                this.chkBoxUnlimitedVM.setEnabled(false);
                this.txtMaxVM.setText(defaultMaxVM);
            }
            this.chkStatus.setAllChecked(rffs.getAnyStatus());
            String[] stateTypes = SystemProcessStatesContentProvider.getStates();
            int i = 0;
            while (i < ISystemProcessRemoteConstants.ALL_STATES_STR.length) {
                this.chkStatus.setChecked((Object)stateTypes[i], rffs.getSpecificState(ISystemProcessRemoteConstants.ALL_STATES_STR[i]));
                ++i;
            }
        }
    }

    protected void resetFields() {
        if (this.txtExeName == null) {
            return;
        }
        this.txtExeName.setText("*");
        this.txtUserName.setText("*");
        this.txtGid.setText("");
        this.txtMinVM.setText("0");
        this.txtMaxVM.setText("");
        this.chkBoxUnlimitedVM.setSelection(true);
        this.txtMaxVM.setEnabled(false);
        this.chkBoxUnlimitedVM.setEnabled(true);
        this.chkStatus.setAllChecked(false);
    }

    protected boolean areFieldsComplete() {
        return this.txtExeName != null;
    }

    public SystemMessage verify() {
        this.errorMessage = null;
        Text controlInError = null;
        this.calledFromVerify = true;
        this.skipEventFiring = true;
        this.errorMessage = this.validateNameInput(this.txtExeName);
        if (this.errorMessage != null) {
            controlInError = this.txtExeName;
        }
        this.errorMessage = this.validateNameInput(this.txtUserName);
        if (this.errorMessage != null) {
            controlInError = this.txtUserName;
        }
        this.errorMessage = this.validateGidInput();
        if (this.errorMessage != null) {
            controlInError = this.txtGid;
        }
        this.errorMessage = this.validateMinVMInput();
        if (this.errorMessage != null) {
            controlInError = this.txtMinVM;
        }
        if (this.errorMessage == null) {
            if (!this.chkBoxUnlimitedVM.getSelection()) {
                this.errorMessage = this.validateMaxVMInput();
                if (this.errorMessage == null) {
                    this.errorMessage = this.validateMinLessThanMax();
                }
            }
            if (this.errorMessage != null) {
                controlInError = this.txtMaxVM;
            }
        }
        if (this.errorMessage == null && this.inputFilterStrings != null && !this.skipUniquenessChecking) {
            boolean notUnique = false;
            String currFilterString = this.getFilterString();
            if (this.containsFilterString(currFilterString)) {
                notUnique = true;
            }
            if (notUnique) {
                this.errorMessage = new SimpleSystemMessage("org.eclipse.rse.processes.ui", "RSEF1007", 4, NLS.bind((String)SystemProcessesResources.MSG_VALIDATE_FILEFILTERSTRING_NOTUNIQUE, (Object)currFilterString));
            }
            controlInError = this.txtExeName;
        }
        if (this.errorMessage != null && !this.dontStealFocus && controlInError != null) {
            controlInError.setFocus();
        }
        this.calledFromVerify = false;
        this.skipEventFiring = false;
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    private boolean containsFilterString(String newString) {
        if (this.inputFilterStrings == null) {
            return false;
        }
        int idx = 0;
        while (idx < this.inputFilterStrings.length) {
            if (this.inputFilterStrings[idx].equals(newString)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    protected SystemMessage validateNameInput(Text txt) {
        if (this.noValidation || this.ignoreChanges) {
            return null;
        }
        this.errorMessage = null;
        if (this.nameValidator != null) {
            this.errorMessage = this.nameValidator.validate(txt.getText().trim());
        }
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    protected SystemMessage validateGidInput() {
        if (this.noValidation || this.ignoreChanges) {
            return null;
        }
        this.errorMessage = null;
        if (this.gidValidator != null) {
            this.errorMessage = this.gidValidator.validate(this.txtGid.getText().trim());
        }
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    protected SystemMessage validateMinVMInput() {
        if (this.noValidation || this.ignoreChanges) {
            return null;
        }
        this.errorMessage = null;
        if (this.vmRangeValidator != null) {
            this.errorMessage = this.vmRangeValidator.validate(this.txtMinVM.getText().trim());
        }
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    protected SystemMessage validateMaxVMInput() {
        if (this.noValidation || this.ignoreChanges || this.chkBoxUnlimitedVM.getSelection()) {
            return null;
        }
        this.errorMessage = null;
        if (this.vmRangeValidator != null) {
            this.errorMessage = this.vmRangeValidator.validate(this.txtMaxVM.getText().trim());
        }
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    protected SystemMessage validateMinLessThanMax() {
        long minVM = 0L;
        long maxVM = 0L;
        try {
            minVM = Long.parseLong(this.txtMinVM.getText());
            maxVM = Long.parseLong(this.txtMaxVM.getText());
        }
        catch (Exception e) {
            return null;
        }
        if (maxVM < minVM) {
            return ProcessesPlugin.getPluginMessage("RSEPG1001");
        }
        return null;
    }

    public String getFilterString() {
        String minVM;
        String gid;
        String userName;
        if (this.txtExeName == null) {
            return this.inputFilterString;
        }
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        String exeName = this.txtExeName.getText().trim();
        if (!exeName.equals("")) {
            rpfs.setName(exeName);
        }
        if (!(userName = this.txtUserName.getText().trim()).equals("")) {
            rpfs.setUsername(userName);
        }
        if (!(gid = this.txtGid.getText().trim()).equals("")) {
            rpfs.setGid(gid);
        }
        if (!(minVM = this.txtMinVM.getText().trim()).equals("")) {
            rpfs.setMinVM(minVM);
        }
        if (this.chkBoxUnlimitedVM.getSelection()) {
            rpfs.setMaxVM("-1");
        } else {
            String maxVM = this.txtMaxVM.getText().trim();
            if (!maxVM.equals("")) {
                rpfs.setMaxVM(maxVM);
            }
        }
        String[] stateStrings = SystemProcessStatesContentProvider.getStates();
        int i = 0;
        while (i < ISystemProcessRemoteConstants.ALL_STATES_STR.length) {
            if (this.chkStatus.getChecked((Object)stateStrings[i])) {
                rpfs.setSpecificState(ISystemProcessRemoteConstants.ALL_STATES_STR[i]);
            }
            ++i;
        }
        return rpfs.toString();
    }

    public void widgetSelected(SelectionEvent event) {
        Object src = event.getSource();
        this.dontStealFocus = true;
        if (src == this.chkBoxUnlimitedVM) {
            this.txtMaxVM.setEnabled(!this.chkBoxUnlimitedVM.getSelection());
            if (!this.chkBoxUnlimitedVM.getSelection()) {
                this.txtMaxVM.setFocus();
                if (this.validateMaxVMInput() == null && !this.txtMinVM.getText().trim().equals("")) {
                    SystemMessage message = this.validateMinLessThanMax();
                    this.fireChangeEvent(message);
                }
            } else {
                this.verify();
            }
        }
        this.dontStealFocus = false;
    }

    public void processTest(Shell shell) {
        if (this.refProvider == null) {
            SystemBasePlugin.logWarning((String)"Programming Error: input subsystem is not set");
            return;
        }
        this.skipUniquenessChecking = true;
        if (this.verify() == null) {
            SystemTestFilterStringAction testAction = new SystemTestFilterStringAction(this.getShell());
            testAction.setSubSystem((ISubSystem)this.refProvider);
            testAction.setFilterString(this.getFilterString());
            try {
                testAction.run();
            }
            catch (Exception exc) {
                SystemMessage msg = SystemMessageDialog.getExceptionMessage((Shell)this.getShell(), (Throwable)exc);
                this.fireChangeEvent(msg);
            }
        }
        this.skipUniquenessChecking = false;
    }
}

